package com.tykj.dev.device.packing.subject.vo;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

import javax.persistence.Lob;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("列装装备存储类")
@Repository
public class AddPack {
    @NotNull(message = "model不能为空")
    @ApiModelProperty(value = "型号", example = "测试型号")
    private String model;

    @NotNull(message = "name不能为空")
    @ApiModelProperty(value = "名称", example = "测试名称")
    private String name;

    @ApiModelProperty(value = "应用类型", example = "1")
    private Integer applyType;

    @ApiModelProperty(value = "配用范围", example = "1")
    private Integer matchingRange;

    @NotNull(message = "invisibleRange不能为空")
    @ApiModelProperty(value = "可见范围", example = "1")
    private Integer invisibleRange;

    @NotNull(message = "type不能为空")
    @ApiModelProperty(value = "形态", example = "1")
    private Integer type;

    @NotNull(message = "style不能为空")
    @ApiModelProperty(value = "类型", example = "1")
    private Integer style;

    @NotNull(message = "secretLevel不能为空")
    @ApiModelProperty(value = "密级(0:绝密,1:机密,2:秘密)", example = "1")
    private Integer secretLevel;

    @ApiModelProperty(value = "列装性质", example = "1")
    private Integer nature;

    @NotNull(message = "status不能为空")
    @ApiModelProperty(value = "列装状态", example = "1")
    private Integer status;

    @ApiModelProperty(value = "生产单位", example = "测试型号")
    private String prodUnit;

    @ApiModelProperty(value = "创建单位", example = "测试创建单位")
    private String createUnit;

    @NotNull(message = "price不能为空")
    @ApiModelProperty(value = "价格", example = "2.000.000")
    private String price;

    @ApiModelProperty(value = "照片名称", example = "没有先填一个空格")
    private String imageName;

    @ApiModelProperty(value = "照片路径", example = "没有先填一个空格")
    private String imageUrl;

    @ApiModelProperty(value = "附件名称", example = "没有先填一个空格")
    private String fileName;

    @ApiModelProperty(value = "附件路径", example = "没有先填一个空格")
    private String fileUrl;

    /**
     * 附件名称集合
     */
    @ApiModelProperty(value = "附件名称")
    private List<FileRet> fileList;


    @ApiModelProperty(value = "父级ID", example = "1")
    private Integer partParentId;

    @ApiModelProperty(value = "列装描述")
    @Lob
    private String description;

    public PackingLibrary toDo() {
        PackingLibrary packingLibraryEntity = new PackingLibrary();
        BeanUtils.copyProperties(this, packingLibraryEntity);
        packingLibraryEntity.setPackingStatus(2);
        packingLibraryEntity.setIsRoot(0);
        packingLibraryEntity.setFileDb(FilesUtil.stringFileToList(fileList));
        return packingLibraryEntity;
    }
}
