package com.tykj.dev.device.packing.subject.vo;

import com.tykj.dev.device.file.entity.FileRet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.stereotype.Repository;

import javax.persistence.Column;
import javax.persistence.Lob;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dengdiyi
 */
@Repository
@Data
@ApiModel("列装更新类")
public class PackingLibraryUpdateVo {

    @NotNull(message = "packingId不能为空")
    @ApiModelProperty(value = "列装库id", example = "1")
    private int packingId;

    @NotNull(message = "model不能为空")
    @ApiModelProperty(value = "型号", example = "测试型号")
    private String model;

    @NotNull(message = "name不能为空")
    @ApiModelProperty(value = "名称", example = "测试名称")
    private String name;

    @ApiModelProperty(value = "应用类型", example = "1")
    private Integer applyType;

    @NotNull(message = "secretLevel不能为空")
    @ApiModelProperty(value = "密级", example = "1")
    private Integer secretLevel;

    @ApiModelProperty(value = "配用范围", example = "1")
    private Integer matchingRange;

    @ApiModelProperty(value = "配用范围", example = "1")
    private String matchingRangeName;

    @NotNull(message = "invisibleRange不能为空")
    @ApiModelProperty(value = "可见范围", example = "1")
    private Integer invisibleRange;

    @NotNull(message = "type不能为空")
    @ApiModelProperty(value = "形态", example = "1")
    private Integer type;

    @NotNull(message = "style不能为空")
    @ApiModelProperty(value = "类型")
    private Integer style;

    @NotNull(message = "status不能为空")
    @ApiModelProperty(value = "列装状态", example = "1")
    private Integer status;

    @ApiModelProperty(value = "列装性质", example = "1")
    private Integer nature;

    @ApiModelProperty(value = "生产单位", example = "测试型号")
    private String prodUnit;

    @ApiModelProperty(value = "创建单位", example = "测试创建单位")
    private String createUnit;

//    @NotNull(message = "price不能为空")
    @ApiModelProperty(value = "价格", example = "2.000.000")
    private String price;

    @ApiModelProperty(value = "照片名称", example = "没有先填一个空格")
    private String imageName;

    @ApiModelProperty(value = "照片路径", example = "没有先填一个空格")
    private String imageUrl;

    @ApiModelProperty(value = "附件名称", example = "没有先填一个空格")
    private String fileName;

    @ApiModelProperty(value = "附件路径", example = "没有先填一个空格")
    private String fileUrl;

    /**
     * 附件名称集合
     */
    @ApiModelProperty(value = "附件名称")
    private List<FileRet> fileList;

    @ApiModelProperty(value = "列装描述")
//    @Lob
    @Column(name = "description",columnDefinition = "TEXT")
    private String description;


}
