package com.tykj.dev.device.questionbank.dao;

import com.tykj.dev.device.questionbank.entity.Problem;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import javax.transaction.Transactional;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName ProblemDao.java
 * @Description 题目dco层
 * @createTime 2021年05月29日 15:01:00
 */

public interface ProblemDao extends JpaRepository<Problem, Integer>, JpaSpecificationExecutor<Problem> {
    List<Problem> findAllByProblemTypeAndProblemLevel(Integer type,int level);

    @Transactional
    @Modifying
    @Query("update Problem o set o.deleteTag = 1  ,o.updateTime=current_timestamp where o.id in :id")
    int updateDeleteTagById(Integer id);

    @Transactional
    @Modifying
    @Query("update Problem o set o.deleteTag = 1  ,o.updateTime=current_timestamp where o.id in :idList")
    int updateDeleteTag(@Param("idList") List<Integer> idList);

}

