package com.tykj.dev.device.repair.repository;

import com.tykj.dev.device.repair.subject.domin.RepairDetail;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface RepairDetailDao extends JpaRepository<RepairDetail, Integer>, JpaSpecificationExecutor<RepairDetail> {
    List<RepairDetail> findByDeviceRepairBillId(Integer billId);
    List<RepairDetail> findByRepairBackBillId(Integer billId);
    List<RepairDetail> findAllByRepairStatusAndOwnUnit(Integer repairStatus,String ownUnit);
    List<RepairDetail> findAllByRepairStatusIn(List<Integer> repairStatus, Sort s);
    List<RepairDetail> findAllByRepairStatusNotIn(List<Integer> repairStatus, Sort s);
    List<RepairDetail> findAllByRepairStatus(Integer repairStatus);
    List<RepairDetail> findAllByRepairStatus(Integer repairStatus, Sort s);
    List<RepairDetail> findAllByDeviceId(Integer deviceId);
    List<RepairDetail> findAllByPid(Integer pid);

    @Transactional
    @Modifying
    @Query("update RepairDetail r set r.record = :record where r.id = :id")
    void updateRecord(String record,Integer id);

    @Transactional
    @Modifying
    @Query("update RepairDetail r set r.record2 = :record where r.id = :id")
    void updateRecord2(String record,Integer id);

    @Transactional
    @Modifying
    @Query("update RepairDetail r set r.record3 = :record where r.id = :id")
    void updateRecord3(String record,Integer id);

    List<RepairDetail> findAllByIdIn(List<Integer> ids);

    @Transactional
    @Modifying
    @Query("update RepairDetail r set r.model = :model where r.deviceId in :ids")
    void updateModel(String model,List<Integer> ids);

    List<RepairDetail> findAllByModel(String model);

    List<RepairDetail> findAllByDeviceIdIn(List<Integer> deviceIds);

    @Transactional
    @Modifying
    @Query("update RepairDetail r set r.remark = :remake where r.id in :repairDetailIds")
    void updateRemakeForClear(@Param("remake") String remake,@Param("repairDetailIds") List<Integer> repairDetailIds);
}
