package com.tykj.dev.device.repair.service;


import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.repair.subject.domin.RepairBackBill;
import com.tykj.dev.device.repair.subject.vo.RepairBillSelectVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;

public interface RepairBackBillService extends RepairPublicService<RepairBackBill> {

    RepairBackBill getOne(Integer id);

    /**
     * @param repairBackBills 异步上链
     */
    void sendHash(List<RepairBackBill> repairBackBills);

    Page<RepairBackBill> getPage(RepairBillSelectVo deviceRepairBillSelectVo, Pageable pageable);

    /**
     * 根据taskId查询单据
     * @param taskId
     * @return
     */
    Map<String,List<FileRet>> getFileList(Integer taskId);
}
