package com.tykj.dev.device.repair.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author dengdiyi
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("维修装备详情类")
public class DeviceDetailVo {

//    @NotNull(message = "id不能为空")
    @Min(value = 1,message = "id不能小于1")
    @ApiModelProperty(value = "维修详情ID", example = "1")
    private Integer id;

    @NotNull(message = "deviceId不能为空")
    @Min(value = 1,message = "deviceId不能小于1")
    @ApiModelProperty(value = "装备ID", example = "1")
    private Integer deviceId;

    @ApiModelProperty(value = "备注")
    private String remark;
}
