package com.tykj.dev.device.repair.subject.vo;

import com.tykj.dev.device.task.subject.vo.TaskUserVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * DATE:2021-6-28
 * Author:zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("装备已领取")
public class EquipmentReceivedVo {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    @ApiModelProperty(name = "父id")
    private Integer pid;

    /**
     * 装备id
     */
    @ApiModelProperty(value = "装备id")
    private Integer deviceId;
    /**
     * 型号
     */
    @ApiModelProperty(value = "型号")
    private String model;
    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;
    /**
     * 类型
     */
    @ApiModelProperty(value = "类型")
    private Integer type;
    /**
     * 装备序列号
     */
    @ApiModelProperty(value = "装备序列号")
    private String seqNumber;
    /**
     * rfid表面号
     */
    @ApiModelProperty(value = "rfid表面号")
    private String rfidSurfaceId;

    /**
     * 维修单id
     */
    @ApiModelProperty(value = "维修单id")
    private Integer deviceRepairBillId;

    /**
     * 所在单位
     */
    @ApiModelProperty(value = "所在单位")
    private String locationUnit;

    @ApiModelProperty(value = "所在单位Id")
    private Integer locationUnitId;

    @ApiModelProperty(value = "所属单位Id")
    private Integer ownUnitId;

    /**
     * 所属单位
     */
    @ApiModelProperty(value = "所属单位")
    private String ownUnit;
    /**
     * 维修状态
     */
    @ApiModelProperty(value = "维修状态")
    private Integer repairStatus;
    /**
     * 维修备注
     */
    @ApiModelProperty(value = "维修备注")
    private String remark;
    /**
     * 维修领取备注
     */
    @ApiModelProperty(value = "维修领取备注")
    private String backRemark;
    /**
     * 已报废换新装备详情主键Id(null代表没有报废，0代表已报废还没有换新)
     */
    @ApiModelProperty(value = "已报废换新装备详情主键Id(null代表没有报废，0代表已报废还没有换新)")
    private Integer newDeviceDetailId;
    /**
     * 创建用户id
     */
    @ApiModelProperty(value = "创建用户id")
    @CreatedBy
    private Integer createUserId;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @CreatedDate
    private Date createTime;
    /**
     * 更新用户id
     */
    @ApiModelProperty(value = "更新用户id")
    @LastModifiedBy
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    @LastModifiedDate
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

    @ApiModelProperty(value = "省维修记录信息")
    private String record;

    @ApiModelProperty(value = "市维修记录信息")
    private String record2;

    @ApiModelProperty(value = "县维修记录信息")
    private String record3;

    @ApiModelProperty(value = "领取单id")
    private Integer repairBackBillId;

    @ApiModelProperty(value = "形态")
    @Transient
    private String typeName;

    @ApiModelProperty(value = "任务uservo")
    private List<TaskUserVo> taskUserVos;

}
