package com.tykj.dev.device.repair.subject.vo;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("配发接收类")
public class RepairReceiveVo {

//    @NotNull(message = "receiveUserbId不能为空")
//    @Min(value = 1,message = "receiveUserbId不能小于1")
    @ApiModelProperty(value = "接收单位B岗")
    private Integer receiveUserbId;

//    @NotNull(message = "taskId不能为空")
    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(value = "任务Id")
    private Integer taskId;

//    @NotNull(message = "billFileName不能为空")
    @ApiModelProperty(value = "配发单附件名字")
    private String billFileName;

//    @NotNull(message = "billFileUrl不能为空")
    @ApiModelProperty(value = "配发单附件URL")
    private String billFileUrl;

//    @NotNull(message = "receiveFileName不能为空")
    @ApiModelProperty(value = "入库附件名字")
    private String receiveFileName;

//    @NotNull(message = "receiveFileUrl不能为空")
    @ApiModelProperty(value = "入库附件URL")
    private String receiveFileUrl;

    @NotNull(message = "receiveCount不能为空")
    @Min(value = 0,message = "receiveCount不能小于0")
    @ApiModelProperty(value = "接收入库数量")
    private Integer receiveCount;

    @NotNull(message = "receiveCheckDetail不能为空")
    @ApiModelProperty(value = "接收入库检查详情")
    private String receiveCheckDetail;

    @NotNull(message = "receiveCheckResult不能为空")
    @ApiModelProperty(value = "接收入库检查结果")
    private String receiveCheckResult;

    @NotNull(message = "status不能为空")
    @ApiModelProperty(value = "是否缺失单据（0：否，1：是）")
    private Integer status = 0;

    @ApiModelProperty(value = "维修完成退回经办人id(省A岗)")
    private Integer startUseraId;

    @ApiModelProperty(value = "维修完成退回审核人id(省B岗)")
    private Integer startUserbId;

    @ApiModelProperty(value = "维修装备详情列表")
    private List<DeviceDetailVo> deviceList = new ArrayList<>();

    @ApiModelProperty(value = "接收方配发单")
    private List<FileRet> receiveFiles;

    @ApiModelProperty(value = "收件单位签章id")
    private String rightSignatureId;

    @ApiModelProperty(value = "单据保存vo")
    private List<ScriptSaveVo> scriptSaveVos;

    @ApiModelProperty(value = "应出库装备数量")
    private Integer sendingCount;

    @ApiModelProperty(value = "已出库装备数量")
    private Integer sendedCount;

    /**
     * 发件单位
     */
    @ApiModelProperty(value = "发件单位")
    private String sendUnit;

    @ApiModelProperty(value = "发件单位Id")
    private Integer sendUnitId;
    /**
     * 收件单位
     */
    @ApiModelProperty(value = "收件单位")
    private String receiveUnit;

    @ApiModelProperty(value = "收件单位Id")
    private Integer receiveUnitId;

    @ApiModelProperty(value = "接收维修装备的型号")
    private List<String> models;
}
