package com.tykj.dev.rfid.entity.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for library_warning_log
 * 库房告警日志
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update library_warning_log set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("库房告警日志")
public class LibraryWarningLog {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;
    /**
     * 告警单位
     */
    @ApiModelProperty(value = "告警单位")
    private String unit;

    @ApiModelProperty(value = "告警单位Id")
    private Integer unitId;

    /**
     * 告警状态
     */
    @ApiModelProperty(value = "告警状态 0为正常 1为异常 ")
    private String status;
    /**
     * /**
     * 告警类型(0:入库异常,1:出库异常,2:盘点异常)
     */
    @ApiModelProperty(value = "告警类型(0:入库异常,1:出库异常,2:盘点异常,3:出库正常,4入库正常)")
    private Integer warningType;
    /**
     * 是否处理 0为否 1为是
     */
    @ApiModelProperty(value = "是否处理 0为未处理 1为已处理 2为正常")
    private Integer warningHandle;
    /**
     * 盘点结果
     */
    @ApiModelProperty(value = "异常情况（正常 新增X台 缺失X台）")
    @Column(name = "inventory_results",columnDefinition ="TEXT")
    private String inventoryResults;
    /**
     * 应有数量
     */
    @ApiModelProperty(value = "应有数量")
    private String dueQuantity;
    /**
     * 实际数量
     */
    @ApiModelProperty(value = "实际数量")
    private String actualQuantity;
    /**
     * 创建用户id
     */
    @ApiModelProperty(value = "创建用户id")
    private Integer createUserId = 0;
    /**
     * 创建时间
     */
    @CreatedDate
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 更新用户id
     */
    @ApiModelProperty(value = "更新用户id")
    private Integer updateUserId = 0;
    /**
     * 更新时间
     */
    @LastModifiedDate
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

}
