package com.tykj.dev.rfid.service;

import com.tykj.dev.rfid.entity.vo.PrintVo;
import com.tykj.dev.rfid.entity.vo.QRCodePrintVo;
import com.tykj.dev.rfid.entity.vo.RfidCreateVo;
import com.tykj.dev.rfid.entity.vo.RfidPrintVo;

import java.util.List;

/**
 * 描述：用于调用RFID打印机打印标签
 *
 * @author HuangXiahao
 * @version V1.0
 * @packageName com.tykj.equipmentrfid.service
 **/

public interface RfidService {

    /**
     * 描述：设置打印机网络端口
     *
     * @param ip   IP
     * @param port 端口号
     */
    void setNetWorkConnection(String ip, Integer port);

    /**
     * 描述：自动扫描本机的打印机接口
     */
    void scanUsbConnection();


    /**
     * 描述：调用打印机打印内容（如出现打印不对齐的情况请联系管理员）
     *
     * @return
     */
    boolean printString(List<PrintVo> printVos);

    /**
     * 描述：调用打印机打印内容（如出现打印不对齐的情况请联系管理员）
     *
     * @return
     */
    boolean printString1(PrintVo printVo);

    /**
     * 描述：生成装备的RFID表面号
     *
     * @param list RFID表面号生成类
     * @return
     */
    List<RfidPrintVo> getRfidNumber(List<RfidCreateVo> list);

    /**
     * 条码打印机 批量打印
     */
    void printByQRcode(List<QRCodePrintVo> qrCodePrintVos);

}
