package com.tykj.dev.rfid.utils;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;


/**
 * 完整标签生成工具
 */
public class DrawImageUtil {

    private static Integer width = 300;

    private static Integer height = 200;

    public static BufferedImage drawImage(Integer id, String string1, String string2, String string3) {
        //创建图片对象
        BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        //基于图片对象打开绘图
        Graphics2D graphics = image.createGraphics();
        //绘图逻辑 START （基于业务逻辑进行绘图处理）
        graphics.setBackground(Color.WHITE);
        graphics.setColor(Color.BLACK);
        graphics.clearRect(0, 0, width, height);
        //偏移量
        int offsetX = 20;
        int offsetY = 40;
        //留白率 例如40就是留白1/40
        int blankRange = 40;
        //计算条形码尺寸
        Integer barCodeWidth = width - (width / blankRange) * 2;//320
        Integer barCodeHeight = (height - offsetY) / 5;//32
        //计算字体尺寸
        int fontSize = Math.min(((height - offsetY) / 5), (width - width / blankRange - offsetX) / maxLength(string1, string2, string3));
        graphics.setFont(new Font("Default", Font.BOLD, fontSize));
        //写入条形码
        graphics.drawImage(BarCodeUtil.createBarCodeImg(String.valueOf(id), barCodeWidth, barCodeHeight), null, width / blankRange, offsetY + height / blankRange);
        //写入字体
        graphics.drawString(string1, offsetX + width / blankRange, barCodeHeight + offsetY + (fontSize + fontSize / 10));
        graphics.drawString(string2, offsetX + width / blankRange, barCodeHeight + offsetY + 2 * (fontSize + fontSize / 10));
        graphics.drawString(string3, offsetX + width / blankRange, barCodeHeight + offsetY + 3 * (fontSize + fontSize / 10));
        image.flush();
        return image;
    }


    public static void writeImage(BufferedImage bufferedImage, String path) {
        try {
            ImageIO.write(bufferedImage, "png", new File(path));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int maxLength(String string1, String string2, String string3) {
        int max;
        max = string1.length();
        if (string2.length() > string1.length()) {
            max = string2.length();
        }
        if (string3.length() > string2.length()) {
            max = string3.length();
        }
        return max;
    }

}
