package com.tykj.dev.device.scrap.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.scrap.service.ScrapBusinessService;
import com.tykj.dev.device.scrap.subject.vo.ScrapOrderOutData;
import com.tykj.dev.device.scrap.subject.vo.StorageScrap;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelDevController.java
 * @Description TODO
 * @createTime 2021年01月10日 13:52:00
 */
@RestController
@Api(tags = "装备报废业务接口模块", description = "包括装备退役业务相关接口")
@AutoDocument
@RequestMapping("/scrapBusiness")
public class ScrapBusinessController {

    @Autowired
    ScrapBusinessService scrapBusinessService;

    /**
     * 省清退中办
     */
    @ApiOperation(value = "省清退中办", notes = "省清退中办")
    @PostMapping(value ="/provinceSendOutSuperior/{userId}")
    public ResponseEntity provinceSendOutSuperior(@PathVariable Integer userId, @RequestBody ScrapOrderOutData scrapOrderOutData){
//        repelBusinessService.provinceSendOutSuperior(userId,orderOutData);
        return ResponseEntity.ok(scrapBusinessService.provinceScrap(userId,scrapOrderOutData));
    }

    /**
     * 退役任务保存草稿
     */
    @ApiOperation(value = "报废任务保存草稿", notes = "报废任务保存草稿")
    @PostMapping(value ="/saveDeviceDecommissioningDraft/{userId}")
    public ResponseEntity saveDeviceDecommissioningDraft(@PathVariable Integer userId, @RequestBody ScrapOrderOutData scrapOrderOutData){
        return ResponseEntity.ok(scrapBusinessService.saveDeviceScrapDraft(userId,scrapOrderOutData));
    }

    /**
     * 出库把任务推送至盖章审核
     */
    @ApiOperation(value = "出库把任务推送至盖章审核", notes = "出库把任务推送至盖章审核")
    @PostMapping(value ="/sealOfAudit/{userId}")
    public ResponseEntity sealOfAudit(@PathVariable Integer userId, @RequestBody ScrapOrderOutData scrapOrderOutData){
        scrapBusinessService.sealOfAudit(userId,scrapOrderOutData);
        return ResponseEntity.ok("退役任务保存草稿成功");
    }

    /**
     *  出库盖章审核调用
     */
    @ApiOperation(value = "报废出库盖章审核调用", notes = "报废出库盖章审核调用")
    @PostMapping(value ="/outSealOfAuditEnd/{reviewTheResults}/{taskId}")
    public ResponseEntity outSealOfAuditEnd(@PathVariable Integer reviewTheResults,@PathVariable Integer taskId){
        scrapBusinessService.outSealOfAuditEnd(taskId,reviewTheResults);
        return ResponseEntity.ok("盖章审核成功");
    }



    /**
     * 省上传中办回执单
     */
    @ApiOperation(value = "省上传中办回执单", notes = "省上传中办回执单")
    @PostMapping(value ="/receiptSingle/{taskId}")
    public ResponseEntity receiptSingle(@PathVariable Integer taskId, @RequestBody StorageScrap storageScrap){
        scrapBusinessService.receiptSingle(taskId,storageScrap);
        return ResponseEntity.ok("省上传中办回执单,成功任务结束");
    }


    /**
     * 报废草稿任务封存
     */
    @ApiOperation(value = "报废草稿任务封存", notes = "报废草稿任务封存")
    @PostMapping(value ="/moveToArchiveScrap/{taskId}")
    public ResponseEntity deleteDrafts(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer taskId){
        scrapBusinessService.deleteDrafts(taskId);
        return ResponseEntity.ok("报废草稿任务封存完成");
    }
}
