package com.tykj.dev.device.scrap.service;

import com.tykj.dev.device.scrap.subject.domin.Scrap;
import com.tykj.dev.device.scrap.subject.vo.ScrapOrderOutData;
import com.tykj.dev.device.scrap.subject.vo.StorageScrap;
import com.tykj.dev.device.task.subject.bto.TaskBto;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName ScrapBusinessService.java
 * @Description TODO
 * @createTime 2021年03月31日 13:14:00
 */
public interface ScrapBusinessService {

    /**
     * 退役任务保存草稿
     */
    TaskBto saveDeviceScrapDraft(Integer userId, ScrapOrderOutData scrapOrderOutData);

    /**
     * 生成省中办报废的任务
     * @param userId 用户id
     * @param scrapOrderOutData 出库对象
     */
    Scrap provinceScrap(Integer userId, ScrapOrderOutData scrapOrderOutData);

    /**
     * 报废上传中办的回执单
     * @param taskId 任务ID
     * @param storageScrap 单据 和装id对象
     */
    void receiptSingle(Integer taskId,  StorageScrap storageScrap);


    /**
     * 出库把任务推送至盖章审核
     */
    void sealOfAudit(Integer userId,ScrapOrderOutData scrapOrderOutData);

    /**
     * 出库盖章审核调用
     * 通过出库
     * 不通过 退回状态
     */
    void outSealOfAuditEnd(Integer taskId,Integer reviewTheResults);

    void deleteDrafts(Integer taskId);
}
