package com.tykj.dev.device.scrap.service.impl;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.scrap.service.ScrapQueryService;
import com.tykj.dev.device.scrap.service.ScrapService;
import com.tykj.dev.device.scrap.subject.domin.Scrap;
import com.tykj.dev.device.scrap.subject.vo.ScrapSelectVo;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.misc.base.BusinessEnum;
import com.tykj.dev.misc.base.StatusEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName ScrapQueryServiceImpl.java
 * @Description TODO
 * @createTime 2021年03月31日 14:14:00
 */
@Service
@Slf4j
public class ScrapQueryServiceImpl implements ScrapQueryService {
    @Autowired
    ScrapService scrapService;

    @Autowired
    TaskService taskService;

    @Override
    public Page<Scrap> findPageScrapList(ScrapSelectVo scrapSelectVo) {
    return scrapService.findPageScrapList(scrapSelectVo);
    }

    @Override
    public Scrap findTaskId(Integer taskId) {
        TaskBto taskBto= taskService.get(taskId);
        return scrapService.findScrap(taskBto.getBillId());
    }

    @Override
    public TaskBto findApplyIdToScrapTask(Integer applyId) {
        Optional<Scrap> scrap= scrapService.findApplyId(applyId);
        if (!scrap.isPresent()){
            return null;
        }else {
            Optional<Task> billIdAndBusinessType = taskService.findBillIdAndBusinessType(scrap.get().getId(), BusinessEnum.SCRAP.id,StatusEnum.ARCHIVE.id);
            if (billIdAndBusinessType.isPresent()){
                TaskBto taskBto=billIdAndBusinessType.get().parse2Bto();
                return taskBto;
            }else {
                log.info("[报废] 根据申请id未查询退役任务 ：{}",applyId);
//                throw new ApiException(ResponseEntity.status(500).body("[报废] 根据申请id未查询退役任务 ："+applyId));
            return null;
            }
        }
    }

    @Override
    public Map<String, List<FileRet>> findByTaskIdToFileMapList(Integer taskId) {
        TaskBto taskBto= taskService.get(taskId);
        return scrapService.findByIdToFileMapList(taskBto.getBillId());
    }
}
