package com.tykj.dev.device.sendback.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.sendback.entity.domain.DeviceRepel;
import com.tykj.dev.device.sendback.entity.vo.CityConfirmRequest;
import com.tykj.dev.device.sendback.entity.vo.ProvinceConfirmRequest;
import com.tykj.dev.device.sendback.service.RepelBusinessService;
import com.tykj.dev.device.sendback.service.SuspensionBillBusinessService;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.beans.Transient;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName SuspensionBillController.java
 * @Description TODO
 * @createTime 2021年09月03日 13:49:00
 */
@RestController
@Api(tags = "中止模块", description = "中止模块相关接口")
@AutoDocument
@RequestMapping("/suspension")
public class SuspensionBillController {

    @Autowired
    SuspensionBillBusinessService suspensionBillBusinessService;

    @PostMapping(value ="/initiateSuspensionBill")
    @ApiOperation(value = "生成中止任务接口", notes = "生成中止任务接口")
    public ResponseEntity initiateRepel(@RequestBody  List<Integer> ids,@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser){
        suspensionBillBusinessService.initiateSuspensionBill1(ids,securityUser);
        return ResponseEntity.ok("发布成功");
    }

    @PostMapping(value ="/initiateSuspensionBill2")
    @ApiOperation(value = "直属单位生成中止任务接口", notes = "生成中止任务接口")
    public ResponseEntity initiateRepel1(@RequestBody  List<Integer> ids,@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser){
        suspensionBillBusinessService.initiateSuspensionBill2(ids,securityUser);
        return ResponseEntity.ok("发布成功");
    }

    @ApiOperation(value = "市确认任务接口", notes = "市确认任务接口")
    @PostMapping(value ="/cityConfirm")
    public ResponseEntity cityConfirm(@RequestBody CityConfirmRequest cityConfirmRequest, @ApiIgnore @AuthenticationPrincipal SecurityUser securityUser){
        suspensionBillBusinessService.cityConfirm(cityConfirmRequest,securityUser);
        return ResponseEntity.ok("市转发省级任务成功");
    }

    @ApiOperation(value = "省确认任务接口", notes = "省确认任务接口")
    @PostMapping(value ="/provinceConfirm")
    public ResponseEntity resolveRepel(@RequestBody ProvinceConfirmRequest provinceConfirmRequest, @ApiIgnore @AuthenticationPrincipal SecurityUser securityUser){
        suspensionBillBusinessService.provinceConfirm(provinceConfirmRequest,securityUser);
        return ResponseEntity.ok("市转发省级任务成功");
    }

    @GetMapping(value = "/select/id/{taskId}")
    @ApiOperation(value = "根据任务查询中止业务详情")
    public ResponseEntity findByTaskId(@PathVariable Integer taskId){

        return ResponseEntity.ok(suspensionBillBusinessService.findByTaskId(taskId));
    }




}
