package com.tykj.dev.device.sendback.entity.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.misc.base.BaseEntity;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceRepel.java
 * @Description DeviceRepel 清退业务id
 * @createTime 2021年01月06日 20:02:00
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@ApiModel("清退账单")
@NoArgsConstructor
@AllArgsConstructor
public class DeviceRepel extends BaseEntity {
    /**
     * 数据id
     */
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;

    /**
     * 清退标题
     */
    @ApiModelProperty(value = "清退标题")
    private String title;
    /**
     * 类型集合多个列装id
     * 页面类型
     */
    @ApiModelProperty(value = "列装id文本 新建时不用填写")
    @Column(name = "fielding",columnDefinition = "TEXT")
    private String fielding;

    /**
     * 描述
     */
    @ApiModelProperty(value = "描述")
    @Column(name = "describes",columnDefinition = "TEXT")
    private String describes;

    /**
     * 任务范围
     *
     */
    @ApiModelProperty(value = "任务范围 新建时不用填写")
    @Column(name = "task_scope",columnDefinition = "TEXT")
    private String taskScope;

    /**
     *征文
     *
     */
    @ApiModelProperty(value = "正文")
    @Column(name = "files",columnDefinition = "TEXT")
    private String files;


    @ApiModelProperty(value = "截至日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date time;

    /**
     * 清退状态
     * 1。全量清退 2。部分清退
     */
    @ApiModelProperty(value = "清退状态 1。全量清退 2。部分清退")
    private Integer repelStatus=1;

    /**
     * 发起人名称
     */
    private String initiateName;

    /**
     * 发起单位
     */
    private String unitName;


    /**
     * 清退类型 0.正常清退 1.退役清退 2.报废清退 3.销毁清退
     */
    private Integer type;

    /**
     * 发起单位id
     */
    private Integer unitId;

    /**
     * 装备序列号
     */
    @Column(name = "seq_numbers",columnDefinition = "TEXT")
    private String seqNumbers;

    /**
     * 导入申请任务使用 市下面区县单位对象
     */
    @Column(name = "equipment_involving_unit",columnDefinition = "TEXT")
    private String equipmentInvolvingUnit;


    /**
     * 清退任务是否办结
     */
    private Integer status=0;

    /**
     * 类型集合多个列装id
     * 页面类型
     */
    @Transient
    @ApiModelProperty(value = "列装id集合")
    private List<Integer> fieldingIds;

    @Transient
    @ApiModelProperty(value = "文件对象集合")
    private List<FileRet> fileRets;

    @Transient
    @ApiModelProperty(value = "清退单位id集合")
    private List<Integer> taskScopes;

    @Transient
    @ApiModelProperty(value = "涉及单位名称集合，查询使用")
    private List<String> unitNames;

    @Transient
    @ApiModelProperty(value = "涉及型号集合 添加填写")
    private List<String> models;

    public DeviceRepel toNew(){
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, DeviceRepel.class);
    }

}
