package com.tykj.dev.device.sendback.entity.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.repair.subject.domin.HistoryRepairBill;
import com.tykj.dev.misc.base.BaseEntity;
import com.tykj.dev.misc.utils.JacksonUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName HistorySendBill.java
 * @Description TODO
 * @createTime 2021年09月22日 13:23:00
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@ApiModel("清退详情")
@NoArgsConstructor
@AllArgsConstructor
@Where(clause = "delete_tag = 0")
public class HistorySendBill {

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;

    private Integer oid;

    @JsonProperty("title")
    private String title;

    @JsonProperty("docNo")
    private String docNo;

    @JsonProperty("applyTime")
    private String applyTime;

    @JsonProperty("handleTime")
    private String handleTime;

    @JsonProperty("applyUnitName")
    private String applyUnitName;

    @JsonProperty("applyUserName")
    private String applyUserName;

    @JsonProperty("applyConfirmUserName")
    private String applyConfirmUserName;

    @JsonProperty("handleUnitName")
    private String handleUnitName;

    @JsonProperty("handleUserName")
    private String handleUserName;

    @JsonProperty("handleConfirmUserName")
    private String handleConfirmUserName;

    @Column(name = "file_rets_send",columnDefinition = "text")
    private String fileRetsSend;

    @Column(name = "file_rets_handle",columnDefinition = "text")
    private String fileRetsHandle;

    /**
     * 1 为退回 2。退役
     */
    private Integer type;

    @Transient
    private List<FileRet> fileRetSendList;

    @Transient
    private List<FileRet> fileRetHandleList;

    /**
     * 删除标记(0:未删除，1:已删除)
     */
    private Integer deleteTag = 0;

    public String toDo(){
        return JacksonUtil.toJSon(this);
    }

    public static HistorySendBill toDb(String data){
        return JacksonUtil.readValue(data,HistorySendBill.class);
    }


}
