package com.tykj.dev.device.sendback.entity.domain;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.checkerframework.checker.units.qual.Temperature;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Transient;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelEscrow.java
 * @Description TODO
 * @createTime 2021年09月13日 16:16:00
 */
@Data
@Entity
@NoArgsConstructor
@AllArgsConstructor
@EntityListeners(AuditingEntityListener.class)
@ApiModel("清退代管单位")
public class RepelEscrow extends BaseEntity {

    /**
     * 代管单位id
     */
    private Integer unitId;

    @Column(name = "device_ids",columnDefinition = "TEXT")
    private String deviceIds;

    @Column(name = "file_rets",columnDefinition = "TEXT")
    private String fileRets;

    /**
     * 直属代管状态
     */
    private Integer escrowStatus;

    /**
     * 清退总任务id
     */
    private Integer repelId;

    @Transient
    private List<FileRet> fileRetList;


    @Transient
    private List<DeviceLibrary> deviceLibraries;


    @Transient
    private String unitName;

    public RepelEscrow(Integer unitId, Integer escrowStatus, Integer repelId) {
        this.unitId = unitId;
        this.escrowStatus = escrowStatus;
        this.repelId = repelId;
    }
}
