package com.tykj.dev.device.sendback.entity.domain;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.device.repair.subject.vo.BillVo;
import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Transient;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName SuspensionBill.java
 * @Description 中止业务 实体类
 * @createTime 2021年08月29日 12:23:00
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@ApiModel("中止业务实体")
@NoArgsConstructor
@AllArgsConstructor
public class SuspensionBill extends BaseEntity {
    /**
     * 标题
     */
    @ApiModelProperty(value = "单据编号")
    private String title;

    /**
     * 编号
     */
    @ApiModelProperty(value = "单据编号")
    private String num;


    /**
     * 发件单位
     */
    @ApiModelProperty(value = "发件单位id")
    private Integer sendUnitId;

    /**
     * 收件单位
     */
    @ApiModelProperty(value = "收件单位id")
    private Integer receiveUnitId;

    /**
     * 发件方经办人id
     */
    @ApiModelProperty(value = "发件方id(A岗位)")
    private Integer sendUserId;

    /**
     * 发件方经办人名称
     */
    @ApiModelProperty(value = "发件方名称(A岗位)")
    private String senderUserName;

    /**
     * 收件单位经办人id
     */
    @ApiModelProperty(value = "发件方id(A岗位)")
    private Integer receiveUserId;

    /**
     * 收件单位经办人名称
     */
    @ApiModelProperty(value = "发件方名称(A岗位)")
    private String receiveUserName;


    @Column(name = "bill_vos",columnDefinition = "TEXT")
    private String billVos;


    @ApiModelProperty(value = "相关任务ID")
    private Integer relatedTaskId;

    @ApiModelProperty(value = "相关任务业务类型")
    private Integer businessType;

    @Column(name = "sender_des",columnDefinition = "TEXT")
    private String senderDes;

    @Column(name = "receive_des",columnDefinition = "TEXT")
    private String receiveDes;

    @Column(name = "file_ret" ,columnDefinition = "TEXT")
    private String fileRets;

    /**
     * 设备信息
     */
    @Transient
    private List<BillVo> billVoList = new ArrayList<>();

    @Transient
    private List<FileRet> fileSet;

    @Transient
    private String senderUnitName;

    @Transient
    private String relatedUnitName;

    @Transient
    private Boolean isEnd;

    @Transient
    private String iSNotCommitDes;


}
