package com.tykj.dev.device.sendback.entity.vo;

import com.tykj.dev.misc.base.CustomPage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelManagementVo.java
 * @Description 清退管理 清退清退vo
 * @createTime 2021年01月23日 12:42:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("清退管理 清退清退vo")
public class RepelManagementVo extends CustomPage {
    @ApiModelProperty(name = "开始清退的年份 默认各式 2020-01-01 00：00：00")
    private Long time;

    @ApiModelProperty(name = "开始清退的年份 默认各式 2020-01-01 00：00：00")
    private Long endTime;

    @ApiModelProperty(name = "单位id")
    private Integer unitId;

    @ApiModelProperty(name = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "型号", example = "bmxx")
    public String model;

    @ApiModelProperty(value = "类型", example = "1")
    public Integer type;

    @ApiModelProperty(value = "密级", example = "1")
    public Integer secretLevel;

    @ApiModelProperty(value = "可见范围(应用领域)", example = "1")
    public Integer invisibleRange;

    @ApiModelProperty(value = "名称", example = "BM-1")
    public String name;

    @ApiModelProperty(value = "配用范围", example = "1")
    public Integer matchingRange;

    @ApiModelProperty(value = "入库类型", example = "1")
    public Integer storageType;

    @ApiModelProperty(value = "管理状态", example = "1")
    public Integer manageStatus;

    @ApiModelProperty(value = "模糊查询内容", example = "测试")
    public String content;

    @ApiModelProperty(value = "型号模糊查询字段")
    private String modelDim;

    @ApiModelProperty(value = "名称模糊查询字段")
    private String nameDim;

    @ApiModelProperty(value = "序列号模糊查询字段")
    private String seqDim;

    @ApiModelProperty(value = "所在单位模糊查询字段")
    private String locationUnitDim;

    @ApiModelProperty(value = "所属单位模糊查询字段")
    private String ownUnitDim;

    @ApiModelProperty(value = "生命状态模糊查询字段")
    private String lifeStatusDim;


}
