package com.tykj.dev.device.sendback.service;

import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.sendback.entity.domain.SuspensionBill;
import com.tykj.dev.device.sendback.entity.vo.CityConfirmRequest;
import com.tykj.dev.device.sendback.entity.vo.ProvinceConfirmRequest;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.entity.User;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName SuspensionBillBusinessService.java
 * @Description 中止业逻辑层
 * @createTime 2021年09月02日 13:43:00
 */
public interface SuspensionBillBusinessService {
    /**
     *自动生成中止任务
     */
    void initiateSuspensionBill(List<Integer> libraryList, Units units, User user);


    /**
     *手动触发中止任务
     */
    void initiateSuspensionBill1(List<Integer> libraryList,SecurityUser securityUser);


    /**
     * 直属单位中止任务生成
     */
     void initiateSuspensionBill2(List<Integer> libraryList,SecurityUser securityUser);

    /**
     * 市级确认任务 - 提交省级确认
     */
    void  cityConfirm(CityConfirmRequest cityConfirmRequest,SecurityUser securityUser);


    /**
     * 省级确认任务 - 任务结束
     */
    void provinceConfirm(ProvinceConfirmRequest provinceConfirmRequest,SecurityUser securityUser);


    /**
     * 根据任务id查询中止业务详情
     */
    SuspensionBill findByTaskId(Integer taskId);
}
