package com.tykj.dev.device.sendback.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.repair.subject.domin.HistoryRepairBill;
import com.tykj.dev.device.repair.subject.vo.HistorySelectVo;
import com.tykj.dev.device.sendback.entity.domain.HistorySendBill;
import com.tykj.dev.device.sendback.entity.vo.HistorySelectSendBillVo;
import com.tykj.dev.device.sendback.repository.HistorySendBillDao;
import com.tykj.dev.device.sendback.service.HistorySendBillService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.ResourceUtils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName HistorySendBillServiceImpl.java
 * @Description TODO
 * @createTime 2021年09月22日 15:05:00
 */
@Service
@Slf4j
public class HistorySendBillServiceImpl implements HistorySendBillService {

    @Autowired
    HistorySendBillDao historySendBillDao;
    @Override
    public void toDb() {
        Path path= Paths.get("file1.txt");
                    List<String> list=historySendBillDao.findAll().stream().map(HistorySendBill::toDo).collect(Collectors.toList());
                    try {
                        Files.write(path,list);
                    } catch (IOException e) {
                        e.printStackTrace();
                    }

    }

    @Override
    public void toDb2() {
        try {
            List<String> list =  Files.readAllLines(Paths.get(ResourceUtils.getURL("classpath:").getPath()+"file1.txt"));
            List<HistorySendBill> historyRepairBills = list
                    .stream()
                    .map(HistorySendBill::toDb)
                    .collect(Collectors.toList());
            historyRepairBills.forEach(
                    historyRepairBill -> {
                        historySendBillDao.save(historyRepairBill);
                    }
            );
        } catch (IOException e) {
            log.error("[toDb2] 找不到文件路径");
        }

    }

    @Override
    public Page<HistorySendBill> findByPageHistoryRepairBill(HistorySelectSendBillVo historySelectSendBillVo) {
        return historySendBillDao.findAll(getSpecificationHistoryRepairBill(historySelectSendBillVo),historySelectSendBillVo.getPageable()).map(historyRepairBill -> {
            historyRepairBill.setFileRetSendList(FilesUtil.stringFileToList(historyRepairBill.getFileRetsSend()));
            historyRepairBill.setFileRetHandleList(FilesUtil.stringFileToList(historyRepairBill.getFileRetsHandle()));
            return historyRepairBill;
        });
    }


    private Specification<HistorySendBill> getSpecificationHistoryRepairBill(HistorySelectSendBillVo historySelectSendBillVo) {
        PredicateBuilder<HistorySendBill> predicateBuilder = Specifications.and();
        if (historySelectSendBillVo.getDocNumDim() != null) {
            predicateBuilder.like("docNo","%"+historySelectSendBillVo.getDocNumDim()+"%" );
        }
        if (historySelectSendBillVo.getTimeDim() != null) {
            predicateBuilder.like("applyTime","%"+historySelectSendBillVo.getTimeDim()+"%");
        }
        predicateBuilder.eq("type",historySelectSendBillVo.getType());
        return predicateBuilder.build();

    }

}
