package com.tykj.dev.device.sendback.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.sendback.entity.domain.RepelEscrow;
import com.tykj.dev.device.sendback.repository.RepelEscrowDao;
import com.tykj.dev.device.sendback.service.RepelEscrowService;
import com.tykj.dev.device.user.cache.UnitsCache;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.JacksonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelEscrowServiceImpl.java
 * @Description TODO
 * @createTime 2021年09月14日 15:42:00
 */
@Service
public class RepelEscrowServiceImpl implements RepelEscrowService {
    @Autowired
    RepelEscrowDao repelEscrowDao;
    @Autowired
    DeviceLibraryService deviceLibraryService;

    @Autowired
    UnitsCache unitsCache;

    @Override
    public void saveRepelEscrowService(RepelEscrow repelEscrow) {
        repelEscrowDao.save(repelEscrow);
    }

    @Override
    public void saveAllRepelEscrowService(List<RepelEscrow> repelEscrows) {
        repelEscrowDao.saveAll(repelEscrows);
    }

    @Override
    public RepelEscrow findByRepelEscrow(Integer repelEscrowID) {
        Optional<RepelEscrow> repelEscrowOptional = repelEscrowDao.findById(repelEscrowID);
        if (repelEscrowOptional.isPresent()){
            RepelEscrow repelEscrow=repelEscrowOptional.get();
            if (repelEscrow.getDeviceIds()!=null){
                repelEscrow.setDeviceLibraries(JacksonUtil.readValue(repelEscrow.getDeviceIds(), new TypeReference<List<DeviceLibrary>>() {
                }));
            }
            if (repelEscrow.getFileRets()!=null){
                repelEscrow.setFileRetList(FilesUtil.stringFileToList(repelEscrow.getFileRets()));
            }
            return repelEscrowOptional.get();
        }else {
            throw new ApiException("[直属清退] 根据数据id查询数据详情失败 id："+repelEscrowID);
        }

    }

    @Override
    public List<RepelEscrow> findAllBillId(Integer billId) {
       List<RepelEscrow>  repelEscrows=repelEscrowDao.findAllByRepelId(billId);
        repelEscrows.forEach(
                repelEscrow -> {
                   Units units = unitsCache.findById(repelEscrow.getUnitId());
                   repelEscrow.setUnitName(units.getName());
                   if (repelEscrow.getDeviceIds()!=null){
                       repelEscrow.setDeviceLibraries(JacksonUtil.readValue(repelEscrow.getDeviceIds(), new TypeReference<List<DeviceLibrary>>() {
                       }));
                   }
                    if (repelEscrow.getFileRets()!=null){
                        repelEscrow.setFileRetList(FilesUtil.stringFileToList(repelEscrow.getFileRets()));
                    }
        });
        return repelEscrows;
    }
}
