package com.tykj.dev.device.sendback.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tykj.dev.device.repair.subject.vo.BillVo;
import com.tykj.dev.device.sendback.entity.domain.SuspensionBill;
import com.tykj.dev.device.sendback.repository.SuspensionBillDao;
import com.tykj.dev.device.sendback.service.SuspensionBillService;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.JacksonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName SuspensionBillServiceImpl.java
 * @Description TODO
 * @createTime 2021年09月02日 13:35:00
 */
@Service
public class SuspensionBillServiceImpl implements SuspensionBillService {

    @Autowired
    SuspensionBillDao suspensionBillDao;

    @Override
    public SuspensionBill saveSuspensionBill(SuspensionBill suspensionBill) {

        return suspensionBillDao.save(suspensionBill);
    }


    @Override
    public SuspensionBill findByIdToSuspensionBill(Integer id) {
        Optional<SuspensionBill> suspensionBillOptional = suspensionBillDao.findById(id);
        if (suspensionBillOptional.isPresent()){
            SuspensionBill suspensionBill=suspensionBillOptional.get();
            suspensionBill.setBillVoList(JacksonUtil.readValue(suspensionBill.getBillVos(), new TypeReference<List<BillVo>>() {
            }));
            return suspensionBill;
        }else {
            throw new ApiException("[中止业务] 根据业务id查询业务详细没找到 id:"+id);
        }
    }
}
