package com.tykj.dev.statistical.cache;

import com.tykj.dev.statistical.service.BigScreenService;
import com.tykj.dev.statistical.service.StatisticalService;
import jdk.nashorn.tools.Shell;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.text.ParseException;

/**
 * @author dengdiyi
 * 统计分析缓存配置类
 */
//@Configuration
@Component

public class CacheConfig {

    @Autowired
    private StatisticalService statisticalService;

    @Bean
//    @DependsOn("init2")
    public StatisticalCache initStatisticalCache() throws ParseException, InterruptedException {
        return new StatisticalCache(statisticalService.getDeviceNum(), statisticalService.getLifeStatus(1),
                statisticalService.getLifeStatus(2), statisticalService.getSelfCheck(), statisticalService.getYearSelfCheck(),
                statisticalService.getRfidWarning(), statisticalService.getRfidWarningDetail(1),
                statisticalService.getRfidWarningDetail(2), statisticalService.getCheckNum(),
                statisticalService.getConfirmCheck(1), statisticalService.getConfirmCheck(2),
                statisticalService.getUserGeneralSituation(), statisticalService.getSelfCheckStat());
    }


}
