package com.tykj.dev.statistical.controller;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName StatisticalController.java
 * @Description TODO
 * @createTime 2020年10月16日 14:53:00
 */

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.file.util.ArrayUtil;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.*;
import com.tykj.dev.misc.base.StatusEnum;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.DeviceModelSort;
import com.tykj.dev.misc.utils.PageUtil;
import com.tykj.dev.misc.utils.ResultUtil;
import com.tykj.dev.statistical.cache.StatisticalCache;
import com.tykj.dev.statistical.service.StatisticalService;
import com.tykj.dev.statistical.vo.DeviceStatistics;
import com.tykj.dev.statistical.vo.ScrappedDestroyedRetiredVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.hibernate.mapping.Array;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.groupingBy;
import static java.util.stream.Collectors.toMap;

@RestController
@Api(tags = "统计业务模块", description = "统计相关接口")
@AutoDocument
@RequestMapping("/statistical")
public class StatisticalController {

    @Autowired
    private StatisticalService statisticalService;

    @Autowired
    private StatisticalCache statisticalCache;

    @Autowired
    private DeviceLibraryService deviceLibraryService;

    @Autowired
    DeviceLibraryDao deviceLibraryDao;

//    @Autowired
//    private ConfigCache configCache;

    /**
     * 查询工作台统计
     * @return 作台统计对象集合
     */
    @ApiOperation(value = "查询工作台统计")
    @GetMapping("/workBench")
    public ResponseEntity workBench(){
        return ResponseEntity.ok(statisticalService.getWorkBenchStat());
    }

    /**
     * 查询各市的装备数量
     * @return 各市装备对象集合
     */
    @ApiOperation(value = "查询各市的装备数量")
    @GetMapping("/devNum")
    public ResponseEntity selectDevNum(){
        return ResponseEntity.ok(statisticalCache.getDevNums());
    }

    /**
     * 查询全省或各市装备生命状态数量
     * @return 全省或各市装备生命状态对象集合
     */
    @ApiOperation(value = "查询全省或各市装备生命状态数量(type:1全省，2全市)")
    @GetMapping("/StateofLife/{type}")
    public ResponseEntity selectStateofLife(@PathVariable Integer type){
        if (type==1){
            return ResponseEntity.ok(statisticalCache.getProvinceDevLifeSectors());
        }
        else if(type==2){
            return ResponseEntity.ok(statisticalCache.getCityDevLifeSectors());
        }
        else {
            throw new ApiException("type只能为1或2");
        }
    }

    /**
     * 查询当前季度各市自查情况
     * @return 各市自查状态对象集合
     */
    @ApiOperation(value = "查询当前季度各市自查情况")
    @GetMapping("/selfInspection")
    public ResponseEntity selectSelfInspection(){
        return ResponseEntity.ok(statisticalCache.getSelfInspections());
    }

    /**
     * 查询年度各季度各市自查情况
     * @return 各市自查状态对象集合
     */
    @ApiOperation(value = "查询年度各季度各市自查情况")
    @GetMapping("/selfInspection/year")
    public ResponseEntity selectYearSelfInspection(){
        return ResponseEntity.ok(statisticalCache.getYearSelfInspections());
    }

    @ApiOperation(value = "查询各市最近一次自查情况")
    @GetMapping("/selfCheckStat")
    public ResponseEntity selfCheckStat(){
        return ResponseEntity.ok(statisticalCache.getSelfCheckVos());
    }

    /**
     * 查询各市核查情况数量
     * @return 各市核查状态对象集合
     */
    @ApiOperation(value = "查询各市核查情况数量")
    @GetMapping("/confirmInspection/{type}")
    public ResponseEntity selectVerification(@PathVariable Integer type) throws ParseException{
        if (type==1){
            return ResponseEntity.ok(statisticalCache.getFirstYearVerifications());
        }
        else if(type==2){
            return ResponseEntity.ok(statisticalCache.getLastYearVerifications());
        }
        else {
            throw new ApiException("type只能为1或2");
        }
    }

    /**
     * 查询专管员概述
     * @return 各市装备生命状态对象集合
     */
    @ApiOperation(value = "查询专管员概述")
    @GetMapping("/generalSituation")
    public ResponseEntity selectGeneralSituation(){
        return ResponseEntity.ok(statisticalCache.getUserGeneralSituation());
    }

    /**
     * 查询告警情况
     * @return 全省告警统计对象集合
     */
    @ApiOperation(value = "查询告警情况")
    @GetMapping("/alarmSituation")
    public ResponseEntity selectAlarmSituation(){
        return ResponseEntity.ok(statisticalCache.getAlarmSituation());
    }

    /**
     * 查询各市告警情况
     * @return 各市告警统计对象集合
     */
    @ApiOperation(value = "查询各市告警情况")
    @GetMapping("/alarmSituation/detail/{type}")
    public ResponseEntity selectAlarmSituationDetail(@PathVariable("type") int type){
        if (type==1){
            return ResponseEntity.ok(statisticalCache.getQuarterAlarmSituations());
        }
        else if(type==2){
            return ResponseEntity.ok(statisticalCache.getYearAlarmSituations());
        }
        else {
            throw new ApiException("type只能为1或2");
        }
    }

    /**
     * 查询业务情况
     * @return 各市装备生命状态对象集合
     */
    @ApiOperation(value = "查询业务情况")
    @GetMapping("/businessSituation/{type}")
    public ResponseEntity selectBusinessSituation(@PathVariable Integer type) throws ParseException {
        return ResponseEntity.ok(statisticalService.getBusinessNum(type));
    }

    /**
     * 查询各市最近一次自查核查数量
     * @return 各市自查核查数量对象集合
     */
    @ApiOperation(value = "查询各市最近一次自查核查数量")
    @GetMapping("/checkNum")
    public ResponseEntity selectCheckNum(){
        return ResponseEntity.ok(statisticalCache.getChecks());
    }

    @ApiOperation(value = "查询所有装备统计列表", notes = "可以通过这个接口查询所有装备统计列表")
    @PostMapping("/device")
    public ResponseEntity selectAllDeviceStatList(@RequestBody DeviceLibrarySelectVo deviceLibrarySelectVo) {
        Boolean hasModelDim = deviceLibrarySelectVo.getModelDim()!=null;
        Boolean hasNameDim = deviceLibrarySelectVo.getNameDim()!=null;
        Boolean hasSeqDim = deviceLibrarySelectVo.getSeqDim()!=null;
        Boolean hasLocationUnitDim = deviceLibrarySelectVo.getLocationUnitDim()!=null;
        Boolean hasOwnUnitDim = deviceLibrarySelectVo.getOwnUnitDim()!=null;
        Boolean hasLifeStatusDim = deviceLibrarySelectVo.getLifeStatusDim()!=null;
        Boolean hasUpdateTimeDim = deviceLibrarySelectVo.getUpdateTimeDim()!=null;
        Boolean hasYear = deviceLibrarySelectVo.getYear()!=null;
        SimpleDateFormat sdf =  new SimpleDateFormat( "yyyy-MM-dd HH:mm:ss" );
        List<DeviceLibrary> resultList = deviceLibraryService.getAllList(deviceLibrarySelectVo);
        resultList.forEach(DeviceLibrary::setConfigName);
        if (hasModelDim||hasLifeStatusDim||hasLocationUnitDim||hasNameDim||hasOwnUnitDim||hasSeqDim||hasYear) {
            resultList = resultList.stream().filter(deviceLibrary -> {
                Boolean containModelDim = !hasModelDim||deviceLibrary.getModel().contains(deviceLibrarySelectVo.getModelDim());
                Boolean containNameDim = !hasNameDim||deviceLibrary.getName().contains(deviceLibrarySelectVo.getNameDim());
                Boolean containSeqDim = !hasSeqDim||deviceLibrary.getSeqNumber().contains(deviceLibrarySelectVo.getSeqDim());
                Boolean containLocationUnitDim = !hasLocationUnitDim||deviceLibrary.getLocationUnit().contains(deviceLibrarySelectVo.getLocationUnitDim());
                Boolean containOwnUnitDim = !hasOwnUnitDim||deviceLibrary.getOwnUnit().contains(deviceLibrarySelectVo.getOwnUnitDim());
                Boolean containLifeStatusDim = !hasLifeStatusDim||deviceLibrary.getLifeStatusName().contains(deviceLibrarySelectVo.getLifeStatusDim());
                Boolean containUpdateTimeDim = !hasUpdateTimeDim||sdf.format(deviceLibrary.getUpdateTime()).contains(deviceLibrarySelectVo.getUpdateTimeDim());
                Boolean sameYear = !hasYear||(deviceLibrary.getUpdateTime()!=null&&deviceLibrary.getUpdateTime().getYear()==deviceLibrarySelectVo.getYear()-1900);
                return containModelDim&&containNameDim&&containSeqDim&&containLocationUnitDim&&containOwnUnitDim&&containLifeStatusDim&&containUpdateTimeDim&&sameYear;
            }).collect(Collectors.toList());
        }
        List<DeviceLibrary> deviceLibraryEntities = resultList;
        deviceLibraryEntities.forEach(DeviceLibrary::setConfigName);
        //新增 已退役 已报废 已退役
        if (deviceLibrarySelectVo.getIsScraped()==0){
            return ScrappedDestroyedRetiredMethod(deviceLibraryEntities,deviceLibrarySelectVo);
        }
        //进行注释
        Page<DeviceLibrary> deviceLibraries = PageUtil.getPerPage(deviceLibrarySelectVo.getPage(),deviceLibrarySelectVo.getSize(),deviceLibraryEntities,deviceLibrarySelectVo.getPageable());
        Map<String,Object> map = new HashMap<>();
//        Map<Integer,String> lifeStatusMap = configCache.getLifeStatusMap();
//        Set<Integer> status = deviceLibraryEntities.stream().map(DeviceLibrary::getLifeStatus).collect(Collectors.toSet());
        List<String> collect = deviceLibraryEntities.stream().map(DeviceLibrary::getModel).distinct().collect(Collectors.toList());
        List<String> modelToSort = DeviceModelSort.modelToSort(collect);
        map.put("pages",deviceLibraries);
        map.put("models",modelToSort);
        //排序加上去重
        List<String> names = deviceLibraryEntities.stream().map(DeviceLibrary::getName).distinct()
                .sorted(Comparator.comparing(String::toString)).collect(Collectors.toList());
        map.put("names",names);
//        map.put("ownUnits",deviceLibraryEntities.stream().map(DeviceLibrary::getOwnUnit).collect(Collectors.toSet()));
//        map.put("locationUnits",deviceLibraryEntities.stream().map(DeviceLibrary::getLocationUnit).collect(Collectors.toSet()));
//        map.put("lifeStatus",status.stream().map(integer -> new LifeStatusVo(integer,lifeStatusMap.get(integer))).collect(Collectors.toList()));
        return ResultUtil.success(map);
    }

    @ApiOperation(value = "根据装备id查询装备详情", notes = "根据装备id查询装备详情")
    @PostMapping("/selectByIds2")
    public ResponseEntity selectByIds2(@RequestBody DeviceSelectIdsVo deviceSelectIdsVo){
        Page<DeviceLibrary> byIds = deviceLibraryDao.findAll(getFindRetiredSpecification(deviceSelectIdsVo),deviceSelectIdsVo.getPageable()).map(DeviceLibrary::setConfigName);

        return ResponseEntity.ok(byIds);
    }


    private Specification<DeviceLibrary> getFindRetiredSpecification(DeviceSelectIdsVo deviceSelectIdsVo) {
        PredicateBuilder<DeviceLibrary> predicateBuilder = Specifications.and();
//        List<Integer> leftStatus=new ArrayList<>();
//        leftStatus.add(com.tykj.dev.config.base.DeviceLifeStatus.RETIRED.id);
        if (deviceSelectIdsVo.getIds()!= null&&deviceSelectIdsVo.getIds().size()!=0) {
            predicateBuilder.in("id",deviceSelectIdsVo.getIds().toArray());
        }
        return predicateBuilder.build();

    }


    /**
     * 按型号，名称，类型组合
     */
    private List<DeviceStatistics> getDeviceStatistics(List<DeviceLibrary> deviceLibraries) {
        List<DeviceStatistics> deviceStatisticsList = new ArrayList<>();
        Map<String, List<DeviceLibrary>> map = deviceLibraries.stream().collect(groupingBy(deviceLibrary -> deviceLibrary.getModel()+"Ǵ"+deviceLibrary.getName()));
        for (String s:map.keySet()) {
            String[] strings = s.split("Ǵ");
            if (strings.length == 2) {
                DeviceStatistics deviceStatistics = new DeviceStatistics();
                deviceStatistics.setModel(strings[0]);
//                deviceStatistics.setName(strings[1]);
//                if ("null".equals(strings[1])){
//                    deviceStatistics.setType(null);
//                    deviceStatistics.setTypeName("-");
//                }
//                else {
//                    deviceStatistics.setType(Integer.valueOf(strings[1]));
//                    deviceStatistics.setTypeName(map.get(s).get(0).setConfigName().getTypeName());
//                }
                deviceStatistics.setName(strings[1]);
                deviceStatistics.setNum(map.get(s).size());
                deviceStatistics.setDeviceIds(map.get(s).stream().map(DeviceLibrary::getId).collect(Collectors.toList()));
                deviceStatisticsList.add(deviceStatistics);
            }
        }
        return deviceStatisticsList;
    }
    //已退役 已报废 已退役
    public ResponseEntity ScrappedDestroyedRetiredMethod(List<DeviceLibrary> libraryList,DeviceLibrarySelectVo deviceLibrarySelectVo){
        //已销毁 10 已报废 5 已退役 12
        List<Integer> lifeStatus = new ArrayList<>(Arrays.asList(5, 10, 12));
        List<ScrappedDestroyedRetiredVo> destroyedRetiredVoList = new ArrayList<>();
        if (lifeStatus.containsAll(deviceLibrarySelectVo.getLifeStatus())){
            //进行组合
//            Map<String, List<DeviceLibrary>> map = libraryList.stream()
//                    .collect(groupingBy(deviceLibrary -> deviceLibrary.getModel() + "Ǵ" + deviceLibrary.getName() + "Ǵ" +
//                            deviceLibrary.getMatchingRangeName()+"Ǵ"+deviceLibrary.getIsPart()));
            LinkedHashMap<String, List<DeviceLibrary>> map =
                    libraryList.stream().collect(groupingBy(deviceLibrary -> deviceLibrary.getModel() + "Ǵ"
                            + deviceLibrary.getName() + "Ǵ" + deviceLibrary.getMatchingRangeName() + "Ǵ" + deviceLibrary.getIsPart(),
                    LinkedHashMap::new, Collectors.toList()));
            if (map.size()>0){
                for (String s : map.keySet()) {
                    String[] strings = s.split("Ǵ");
                    //型号 名称  配用范围
                    ScrappedDestroyedRetiredVo scrappedDestroyedRetiredVo = new ScrappedDestroyedRetiredVo();
                    scrappedDestroyedRetiredVo.setModel(strings[0]);
                    scrappedDestroyedRetiredVo.setName(strings[1]);
                    scrappedDestroyedRetiredVo.setMatchingRangeName(strings[2]);
                    scrappedDestroyedRetiredVo.setIsPart(Integer.valueOf(strings[3]));
                    scrappedDestroyedRetiredVo.setNum(map.get(s).size());
                    List<Integer> ids = new ArrayList<>();
                    List<DeviceLibrary> deviceLibraries = map.get(s);
                    ids = deviceLibraries.stream().map(DeviceLibrary::getId).collect(Collectors.toList());
//                    for (List<DeviceLibrary> deviceLibraryList : map.values()) {
//                        deviceLibraryList.forEach(
//                                deviceLibrary -> {
//                                    ids.add(x.getId());
//                                }
//                        );
//                    }
                    scrappedDestroyedRetiredVo.setDevicesId(ids);
                    destroyedRetiredVoList.add(scrappedDestroyedRetiredVo);
                }
            }
        }
        Map<String,Object> map = new HashMap<>();
        Page<ScrappedDestroyedRetiredVo> page = PageUtil.getPerPage(deviceLibrarySelectVo.getPage(), deviceLibrarySelectVo.getSize(), destroyedRetiredVoList, deviceLibrarySelectVo.getPageable());
        map.put("pages",page);
        //排序加上去重
        List<String> names = destroyedRetiredVoList.stream().map(ScrappedDestroyedRetiredVo::getName).distinct()
                .sorted(Comparator.comparing(String::toString)).collect(Collectors.toList());
        map.put("names",names);
        List<String> models = destroyedRetiredVoList.stream().map(ScrappedDestroyedRetiredVo::getModel).distinct().collect(Collectors.toList());
        List<String> modelToSort = DeviceModelSort.modelToSort(models);
        map.put("models",modelToSort);
        return ResponseEntity.ok(map);
    }


}
