package com.tykj.dev.device.storage.subject.vo;

import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("入库详情类")
public class StorageBillDetailVo {

    @ApiModelProperty(value = "配件列表")
    List<StorageBillDetailVo> list;

    @ApiModelProperty(value = "列装id")
    private Integer packingId;

    @ApiModelProperty(value = "入库数量")
    private Integer storageCount;

    @ApiModelProperty(value = "序列号区间")
    private String seqInterval;

    @ApiModelProperty(value = "生产号区间")
    private String prodInterval;

    @ApiModelProperty(value = "列装装备")
    private PackingLibrary packingLibrary;

    @ApiModelProperty(value = "装备存放位置",notes = "默认是库房")
    private String storageLocation;

    @ApiModelProperty(value = "装备存放位置的id",notes = "默认是库房id")
    private Integer storageLocationId;
}
