package com.tykj.dev.device.task.repository;

import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.domin.Task;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Optional;

/**
 * @author dengdiyi
 */
public interface TaskDao extends JpaRepository<Task, Integer>, JpaSpecificationExecutor<Task> {

    Optional<List<Task>> findAllByOwnUnitInAndParentTaskId(List<Integer> ownIds, Integer parentId);

    /**
     * @param billId       账单id
     * @param businessType 业务类型
     *                     根据账单Id和业务类型查询task
     */
    Optional<Task> findByBillIdAndBusinessType(Integer billId, Integer businessType);

    /**
     * @param billId       账单id
     * @param businessType 业务类型
     *                     根据账单Id和业务类型查询task
     * @param billStatus 业务状态
     */
    Optional<Task> findByBillIdAndBusinessTypeAndBillStatusNot(Integer billId, Integer businessType,Integer billStatus);
    /**
     * 根据账单id、业务类型、任务状态查询task
     *
     * @param billId       账单id
     * @param businessType 业务类型
     * @param billStatus   任务状态
     */
    List<Task> findAllByBillIdAndBusinessTypeAndBillStatus(Integer billId, Integer businessType, Integer billStatus);

    /**
     * 根据账单id、业务类型、任务状态查询task
     *
     * @param billId       账单id
     * @param businessType 业务类型
     */
    List<Task> findAllByBillIdAndBusinessType(Integer billId, Integer businessType);


    List<Task> findAllByBusinessTypeAndParentTaskId(Integer businessType, Integer taskId);


    List<Task> findAllByBusinessTypeAndParentTaskIdIn(Integer businessType, List<Integer> taskId);



    /**
     * 根据账单id、业务类型、以及父id为null
     *
     * @param billId       账单ID
     * @param businessType 业务类型
     */
    Task findAllByParentTaskIdIsNullAndBillIdAndBusinessType(Integer billId, Integer businessType);

    List<Task> findAllByParentTaskIdAndBusinessType(Integer parentTaskId,Integer type);

    @Query("select o.billId from Task o where o.id=?1")
    Integer findBillIdByTaskId(int taskId);

    @Query("select o.billId from Task  o where  o.id=?1 and o.businessType=?2")
    Integer findBillId(int id, int businessType);

    Task findByParentTaskIdAndBusinessType(int parentTaskId, int businessType);

    List<Task> findTaskEntitiesByParentTaskIdAndAndBusinessType(Integer parentTaskId,Integer businessType);

    List<Task> findAllByParentTaskId(Integer parentTaskId);

    /**
     * 根绝parentid 查task
     * @param ids parentid
     * @return tasks
     */
    List<Task> findAllByParentTaskIdIn(List<Integer> ids);
    Task findByBusinessTypeAndOwnUnitAndBillStatus(Integer type, Integer ownUnit, Integer billStatus);

    Task findByParentTaskIdAndAndTitle(Integer parentId, String title);

    List<Task> findAllByBusinessType(Integer businessType);

    List<Task> findAllByBusinessTypeAndBillStatus(Integer businessType,Integer billStatus);

    List<Task> findAllByBillIdInAndBusinessType(List<Integer> ids,Integer type);

    List<Task> findAllByBusinessTypeAndCustomInfo(Integer businessType,String customInfo);

    List<Task> findAllByBusinessTypeAndCustomInfoAndBillStatus(Integer businessType,String customInfo,Integer billStatus);

    List<Task> findAllByBusinessTypeAndBillIdIn(Integer businessType,List<Integer> billIds);
    //zsp

    Task findByParentTaskId(Integer parentTaskId);

    //zsp
    List<Task> findAllByBusinessTypeAndOwnUnitAndCustomInfo(Integer businessType, Integer ownUnit,String customInfo);

    List<Task> findAllByIdIn(List<Integer> ids);
}
