package com.tykj.dev.device.train.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.excel.utils.ExcelStyleUtil;
import com.tykj.dev.device.excel.utils.ExcelUtil;
import com.tykj.dev.device.train.entity.vo.UserExcel;
import com.tykj.dev.device.user.base.ret.LeftNavigation;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.service.UnitsService;
import com.tykj.dev.device.user.subject.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName GenerateTestPaperController.java
 * @Description TODO
 * @createTime 2021年06月02日 18:34:00
 */
@RestController
@RequestMapping(value = "/test")
@AutoDocument
@Api(tags = "测试接口", description = "测试接口")
public class GenerateTestPaperController {
    @Autowired
    UnitsService unitsService;

    @Autowired
    UserService userService;


    @GetMapping(value = "/excel/user")
    @ApiOperation(value = "导出用户列表", notes = "导出用户列表")
    public ResponseEntity excelUser(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, HttpServletRequest request, HttpServletResponse response) {
        LeftNavigation leftNavigation= unitsService.findLeftNavigation(securityUser);
        List<UserExcel> list=new ArrayList<>();

        for (LeftNavigation leftNavigation1:leftNavigation.getLeftNavigations()){
            if (leftNavigation1.getType()==2){
                userService.findAllByUnite(leftNavigation1.getId()).forEach(
                        user -> {
                            UserExcel userExcel=new UserExcel();
                            userExcel.setUnit(leftNavigation1.getName());
                            userExcel.setArea(leftNavigation.getName());
                            userExcel.setName(user.getName());
                            userExcel.setDes(user.getUsername());
                            list.add(userExcel);
                        }
                );
            }else {
                for (LeftNavigation leftNavigation2:leftNavigation1.getLeftNavigations()){

                            userService.findAllByUnite(leftNavigation2.getId()).forEach(
                                    user -> {
                                        UserExcel userExcel=new UserExcel();
                                        userExcel.setUnit(leftNavigation2.getName());
                                        userExcel.setArea(leftNavigation1.getName());
                                        userExcel.setName(user.getName());
                                        userExcel.setDes(user.getUsername());
                                        list.add(userExcel);
                                    }
                            );

                        }
            }
        }
        ExportParams exportParams = new ExportParams("xxx","xxx", ExcelType.XSSF);
        exportParams.setStyle(ExcelStyleUtil.class);
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams,UserExcel.class, list);
        ExcelUtil.downloadExcel(request, response, workbook, "xxx");
        return ResponseEntity.ok("ok");
    }

}
