package com.tykj.dev.device.train.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.train.entity.vo.WorkHandoverAddVo;
import com.tykj.dev.device.train.entity.vo.WorkHandoverEndAddVo;
import com.tykj.dev.device.train.service.WorkHandoverService;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName HandoverController.java
 * @Description 工作交接服务层
 * @createTime 2020年08月19日 09:36:00
 */
@RestController
@RequestMapping(value = "/user/handover")
@AutoDocument
@Api(tags = "工作交接", description = "工作交接")
public class HandoverController {

    @Autowired
    WorkHandoverService workHandoverService;

    @Autowired
    UserService userService;

    @GetMapping(value = "/{userId}")
    @ApiOperation(value = "根据用户id查询交接用户详情", notes = "成功返回handoverUser对象集合")
    public ResponseEntity getHandoverUser(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer userId) {

        return ResponseEntity.ok(userService.findByIdHandoverUser(userId));
    }

    @PostMapping(value = "/create")
    @ApiOperation(value = "新建工作交接")
    public ResponseEntity getHandoverUser(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody WorkHandoverAddVo workHandoverAddVo) {

        return ResponseEntity.ok(workHandoverService.createWorkHandover(workHandoverAddVo, securityUser));
    }

    @PostMapping(value = "/uploadDocuments")
    @ApiOperation(value = "完结工作交接")
    public ResponseEntity getHandoverUser(@RequestBody WorkHandoverEndAddVo workHandoverEndAddVo) {

        return ResponseEntity.ok(workHandoverService.endWorkHandover(workHandoverEndAddVo));
    }

    @GetMapping(value = "/query/{workId}")
    @ApiOperation(value = "查询")
    public ResponseEntity getHandoverUser(@PathVariable Integer workId) {

        return ResponseEntity.ok(workHandoverService.findById(workId));
    }

    /**
     * 查询移交人
     */
    @GetMapping(value = "/handedList")
    @ApiOperation(value = "查询移交人")
    public ResponseEntity handedList(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser) {

        return ResponseEntity.ok(workHandoverService.handedList(securityUser));
    }

    /**
     * 工作交接-查询交接人下拉
     */
    @GetMapping(value = "/userList")
    @ApiOperation(value = "工作交接-查询交接人下拉")
    public ResponseEntity userList(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser) {
        return ResponseEntity.ok(userService.findByUniteId1(securityUser.getCurrentUserInfo().getUnitsId()).stream().filter(userShenRe -> userShenRe.getTrainStatus()!=5).collect(Collectors.toList()));
    }


}
