package com.tykj.dev.device.train.entity;

import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Transient;
import java.util.Map;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName GenerateTestPaper.java
 * @Description TODO
 * @createTime 2021年05月30日 16:37:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@EntityListeners(AuditingEntityListener.class)
@Entity
@ApiModel(value = "生成试卷vo", description = "生成试卷vo")
public class GenerateTestPaper extends BaseEntity {

    private Integer trainId;

    @ApiModelProperty(value = "选择题的分数", example = "bmxx", name = "chooseScore")
    private Integer chooseScore;

    @ApiModelProperty(value = "判断题分数", example = "bmxx", name = "chooseScore")
    private Integer judgeScore;

    @ApiModelProperty(value = "多选题分数", example = "bmxx", name = "chooseScore")
    private Integer multipleChoiceScore;

    @ApiModelProperty(value = "简单题分数", example = "bmxx", name = "chooseScore")
    private Integer shortAnswerScore;

    @ApiModelProperty(value = "选择题的总数", example = "bmxx", name = "chooseScore")
    private Integer chooseSubjectCount;

    @ApiModelProperty(value = "判断题总数", example = "bmxx", name = "chooseScore")
    private Integer judgeSubjectCount;

    @ApiModelProperty(value = "多选题总数", example = "bmxx", name = "chooseScore")
    private Integer multipleChoiceSubjectCount;

    @ApiModelProperty(value = "简单题总数", example = "bmxx", name = "chooseScore")
    private Integer shortAnswerSubjectCount;

    @Transient
    @ApiModelProperty(value = "选择题 key为等级 value 数量", example = "bmxx", name = "chooseCount")
    private Map<Integer,Integer> chooseCount;

    @Transient
    @ApiModelProperty(value = "判断题 key为等级 value 数量", example = "bmxx", name = "judgeCount")
    private Map<Integer,Integer> judgeCount;

    @Transient
    @ApiModelProperty(value = "多选题 key为等级 value 数量", example = "bmxx", name = "multipleChoiceCount")
    private Map<Integer,Integer> multipleChoiceCount;

    @Transient
    @ApiModelProperty(value = "简单题 key为等级 value 数量", example = "bmxx", name = "shortAnswerCount")
    private Map<Integer,Integer> shortAnswerCount;


}
