package com.tykj.dev.device.train.entity;

import com.tykj.dev.device.train.entity.vo.SubjectVo;
import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Transient;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName OnlineTainUserTime.java
 * @Description 记录用户每一个课题的学习是否完成
 * @createTime 2021年06月02日 14:36:00
 */
@ApiModel("线上培训用户学习对象")
@AllArgsConstructor
@NoArgsConstructor
@EntityListeners(AuditingEntityListener.class)
@Data
@Entity
public class OnlineTainUserTime extends BaseEntity {
    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", example = "bmxx", name = "userId")
    private Integer userId;
    /**
     * 培训id
     */
    @ApiModelProperty(value = "培训id", example = "bmxx", name = "trainId")
    private Integer trainId;

    @Column(name = "subject_vos", columnDefinition = "TEXT")
    private String subjectVos;

    @Transient
    @ApiModelProperty(value = "课件对象", example = "bmxx", name = "subjectVoList")
    private List<SubjectVo> subjectVoList;

    /**
     * 是否可以考试 1.可以 0.不可以
     */
    @ApiModelProperty(value = "是否可以考试 1.可以 0.不可以", example = "bmxx", name = "isNotCanExam")
    private Integer isNotCanExam=0;

    @Transient
    @ApiModelProperty(value = "任务id", example = "bmxx", name = "taskId")
    private Integer taskId;

}
