package com.tykj.dev.device.train.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.train.entity.vo.TrainUserExcelVo;
import com.tykj.dev.device.user.subject.entity.Mgrcert;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.persistence.*;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UserTranitVo.java
 * @Description TODO
 * @createTime 2020年08月18日 17:35:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "培训人员信息")
public class TrainUser {
    /**
     * 数据id
     */
    @Id
    @ApiModelProperty(value = "数据ID", name = "id", example = "12321L")
    @GeneratedValue
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    /**
     * 培训id
     */
    @ApiModelProperty(value = "培训id", name = "userId", example = "12321L")
    private Integer trainId;

    /**
     * 用户
     */
    @ApiModelProperty(value = "用户数据ID", name = "userId", example = "12321L")
    private Integer userId;

    /**
     * 真实名称
     */
    @Excel(name = "名称", orderNum = "1", width = 30, needMerge = true)
    @ApiModelProperty(value = "真实名称", name = "name", example = "12321L")
    private String name;


    /**
     * 移动电话
     */
    @Excel(name = "移动电话", orderNum = "1", width = 30, needMerge = true)
    @ApiModelProperty(value = "移动电话", name = "mobile", example = "12321L")
    private String mobile;


    /**
     * 身份证
     */
    @Excel(name = "身份证", orderNum = "1", width = 30, needMerge = true)
    @ApiModelProperty(value = "身份证", name = "idCard", example = "12321L")
    private String idCard;

    /**
     * 性别
     */
    @Excel(name = "性别", orderNum = "1", width = 30, needMerge = true)
    @ApiModelProperty(value = "性别", name = "sex", example = "12321L")
    private Integer sex;

    /**
     * 职务
     */
    @ApiModelProperty(value = "用户职务", name = "position")
    private Integer position;

    /**
     * 用户单位
     */
    @ApiModelProperty(value = "用户单位", name = "unitsName", example = "12321L")
    private String unitsName;

    /**
     * 用户单位id
     */
    @ApiModelProperty(value = "用户单位id", name = "unitsId", example = "12321L")
    private Integer unitsId;

    /**
     * 考勤
     */
    @ApiModelProperty(value = "考勤", name = "attendance")
    private String attendance;

    /**
     * 分数
     */
    @ApiModelProperty(value = "分数", name = "score")
    private String score;

    /**
     * 评价
     */
    @ApiModelProperty(value = "评价", name = "evaluation")
    private String evaluation;

    /**
     * 是否报名 1.报名 2.不报名
     */
    @ApiModelProperty(value = "是否报名 1.报名 2.不报名", name = "certificate")
    private Integer isSignUp;


    @ApiModelProperty(value = "不报名的备足", name = "certificate")
    private String note;


    @ApiModelProperty(value = "是否发证", name = "certificate")
    private Integer certificate;


    @ApiModelProperty(value = "到达日期", name = "arriveTime")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date arriveTime;


    @ApiModelProperty(value = "离开日期", name = "leaveTime")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date leaveTime;


    @ApiModelProperty(value = "到达就餐 0.无 1.午饭 2.晚饭", name = "arriveMeal")
    private String arriveMeal;


    @ApiModelProperty(value = "离开就餐 0.无 1.午饭 2.晚饭", name = "leaveMeal")
    private String leaveMeal;

    @ApiModelProperty(value = "是否必须报名 1.必须 2.不必须", name = "certificate")
    private Integer  isNotJoinUserId;

    @ApiModelProperty(value = "线上人员状态 1.未提交 2.已提交 3.已批阅", name = "certificate")
    private Integer  onlineStatus=1;

    @ApiModelProperty(value = "区块链RID",name = "recordId")
    private String recordId;

    @Transient
    private Mgrcert mgrcert;

    public TrainUserExcelVo toTrainUserExcelVo(){
        ModelMapper mapper = BeanHelper.getUserMapper();
        TrainUserExcelVo trainUserExcelVo = mapper.map(this, TrainUserExcelVo.class);
        if (this.getSex()==0){
            trainUserExcelVo.setSexString("男");
        }else {
            trainUserExcelVo.setSexString("女");
        }
        if (this.getPosition()==0) {
            trainUserExcelVo.setPositionString("领导");
        }else {
            trainUserExcelVo.setPositionString("干事");
        }

        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        Instant instant = this.getLeaveTime().toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime LeaveTime=instant.atZone(zoneId).toLocalDateTime();
        Instant instant1 = this.getArriveTime().toInstant();
        LocalDateTime ArriveTime=instant1.atZone(zoneId).toLocalDateTime();
        trainUserExcelVo.setArriveTime(ArriveTime.format(df));
        trainUserExcelVo.setLeaveTime(LeaveTime.format(df));
        trainUserExcelVo.setLeaveMealString(this.leaveMeal);
        trainUserExcelVo.setArriveMealString(this.arriveMeal);
        int daysNum=(int)(LeaveTime.toLocalDate().toEpochDay() - ArriveTime.toLocalDate().toEpochDay());
        if (daysNum > 0){
            trainUserExcelVo.setDayNum(daysNum);
        }else {
            trainUserExcelVo.setDayNum(0);
        }

        return trainUserExcelVo;
    }

}
