package com.tykj.dev.device.train.entity;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.train.entity.vo.WorkHandoverUserVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName WorkHandover.java
 * @Description TODO
 * @createTime 2020年09月17日 13:14:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@EntityListeners(AuditingEntityListener.class)
public class WorkHandover {
    /**
     * 工作交接id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(value = "工作交接id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer workHandoverId;

    /**
     * 发起人id
     */
    private Integer  initiateUserId;

    /**
     * 交接相关人员
     */
    @Column(name = "work_handover_users",columnDefinition = "TEXT")
    private String workHandoverUsers;

    /**
     * 监交人
     */
    private String inUserName;

    /**
     * 上级领导
     */
    private String leadershipName;


    /**
     * 工作交接签章文件 db
     */
    @Column(name = "file" ,columnDefinition = "TEXT")
    private String file;

    /**
     * 状态 1.新建 2.完成
     */
    private Integer status=1;

    @ApiModelProperty(value = "区块链RID",name = "recordId")
    private String recordId;

    /**
     * 工作交接单据集合
     */
    @Transient
    private List<FileRet> fileRets;

    /**
     * 本次交接人员信息组
     */
    @Transient
    private List<WorkHandoverUserVo> workHandoverUserVoList;

    /**
     * 本次交接装备信息清单
     */
    @Transient
    private List<WorkHandoverDev> workHandoverDevs;
}
