package com.tykj.dev.device.train.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TestPaperListVo.java
 * @Description 批阅页面上方滚动条
 * @createTime 2021年06月15日 17:22:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "批阅对象的集合", description = "批阅对象的集合")
public class TestPaperListVo {

    private Integer id;
    /**
     * 总分
     */
    @ApiModelProperty(value = "总分（不）", example = "bmxx", name = "taskId")
    private Float countScore;

    /**
     * 试卷所属用户id
     */
    @ApiModelProperty(value = "用户id", example = "bmxx", name = "taskId")
    private Integer userId;

    /**
     * 试卷所属用户名称
     */
    @ApiModelProperty(value = "用户名称", example = "bmxx", name = "taskId")
    private String userName;

    @ApiModelProperty(value = "培训id", example = "bmxx", name = "taskId")
    private Integer trainId;

    @ApiModelProperty(value = "任务id", example = "bmxx", name = "taskId")
    private Integer taskId;

    /**
     * 0。待批阅 1。批阅完成
     */
    private Integer status = 0;


}
