package com.tykj.dev.device.train.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.train.entity.GenerateTestPaper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName InTrainVo.java
 * @Description 报名中
 * @createTime 2020年08月17日 23:45:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "报名中培训返回的对象", description = "报名中培训的对象")
public class TrainRegistrationVo {
    /**
     * 培训id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "培训id")
    private Integer trainId;

    /**
     * 培训主题
     */
    @ApiModelProperty(value = "培训主题")
    private String name;

    /**
     * 报名截止时间
     */
    @ApiModelProperty(value = "报名截止时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date trainTime;
    /**
     * 发起人 originator
     */
    @ApiModelProperty(value = "发起人")
    private String originatorName;

    /**
     * 发起人 originator
     */
    @ApiModelProperty(value = "发起人id")
    private Integer originatorId;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位名称")
    private String unitsName;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位")
    private Integer unitsId;

    /**
     * 培训开始时间
     */
    @ApiModelProperty(value = "培训开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startTime;
    /**
     * 培训结束时间
     */
    @ApiModelProperty(value = "培训结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endTime;

    /**
     * 培训地点
     */
    @ApiModelProperty(value = "培训地点")
    private String trainLocation;

    /**
     * 主讲人
     */
    @ApiModelProperty(value = "主讲人")
    private String speakerUserId;


    @ApiModelProperty(value = "培训资料集合")
    private List<FileRet> trainDataFileList;

    /**
     * 培训简介
     */
    @ApiModelProperty(value = "trainSynopsis")
    private String trainSynopsis;

    /**
     * 单位已报名人员信息
     */
    @ApiModelProperty(value = "signUpTrainUserToUnitVo")
    private List<TrainUserToUnitVo> signUpTrainUserToUnitVo;

    /**
     * 单位未报名人员信息
     */
    @ApiModelProperty(value = "noSignUpTrainUserToUnitVo")
    private List<TrainUserToUnitVo> noSignUpTrainUserToUnitVo;

    @ApiModelProperty(value = "isEnd",name = "是否可以结束报名")
    private Boolean isEnd;


    @ApiModelProperty(value = "课件集合")
    private List<CoursewareFile> coursewareFileList;


    /**
     * 培训类别
     */
    @ApiModelProperty(value = "培训类别", name = "trainType")
    private Integer trainType;

    /**
     * 考试时间限制
     */
    private Integer examinationTL;

    @ApiModelProperty(value = "试卷模版", name = "generateTestPaper")
    private GenerateTestPaper generateTestPaper;

}
