package com.tykj.dev.device.train.entity.vo;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.train.entity.GenerateTestPaper;
import com.tykj.dev.device.train.entity.TrainTheme;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.persistence.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TrainThemeAddVo.java
 * @Description TODO
 * @createTime 2020年08月13日 14:46:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "新建培训对象", description = "新建培训对象")
public class TrainThemeAddVo {

    /**
     * 培训主题
     */
    @ApiModelProperty(value = "培训主题")
    private String name;

    /**
     * 报名截止时间
     */
    @ApiModelProperty(value = "报名截止时间")
    private Date trainTime;
    /**
     * 发起人 originator
     */
    @ApiModelProperty(value = "发起人")
    private String originatorName;

    /**
     * 发起人 originator
     */
    @ApiModelProperty(value = "发起人id")
    private Integer originatorId;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位名称")
    private String unitsName;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位")
    private Integer unitsId;

    /**
     * 培训开始时间
     */
    @ApiModelProperty(value = "培训开始时间")
    private Date startTime;
    /**
     * 培训结束时间
     */
    @ApiModelProperty(value = "培训结束时间")
    private Date endTime;

    /**
     * 培训地点
     */
    @ApiModelProperty(value = "培训地点")
    private String trainLocation;

    /**
     * 主讲人
     */
    @ApiModelProperty(value = "主讲人")
    private String speakerUserId;

    @ApiModelProperty(value = "培训资料集合")
    private List<FileRet> trainDataFileList;

    /**
     * 培训简介
     */
    @ApiModelProperty(value = "trainSynopsis")
    private String trainSynopsis;


    @ApiModelProperty(value = "试卷模版",name = "generateTestPaper")
    private GenerateTestPaper generateTestPaper;

    /**
     * 考试时间限制
     */
    @ApiModelProperty(value = "考试时间限制",name = "examinationTL")
    private Integer examinationTL;

    /**
     * 需要参加的单位
     */
    @ApiModelProperty(value = "参会单位 集合",name = "unitsIds")
    private List<Integer> unitsIds;

    /**
     * 培训状态 1报名中  2待培训  3培训中
     */
    @ApiModelProperty(value = "培训状态")
    private Integer trainStatus;

    @ApiModelProperty(value = "课件集合")
    @Transient
    private List<CoursewareFile> coursewareFileList = new ArrayList<>();
    /**
     * 培训类别
     */
    @ApiModelProperty(value = "培训类别", name = "trainType")
    private Integer trainType;

    public TrainTheme toDo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, TrainTheme.class);
    }
}
