package com.tykj.dev.union;

import com.tykj.dev.config.Log;
import com.tykj.dev.config.LogType;
import com.tykj.dev.config.Param;
import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.allot.service.AllotBackBillService;
import com.tykj.dev.device.allot.service.AllotBillService;
import com.tykj.dev.device.allot.subject.domin.AllotBackBill;
import com.tykj.dev.device.allot.subject.domin.AllotBill;
import com.tykj.dev.device.apply.service.DeviceApplyBillService;
import com.tykj.dev.device.apply.subject.domin.DeviceApplyBill;
import com.tykj.dev.device.confirmcheck.repository.DeviceCheckBillDao;
import com.tykj.dev.device.confirmcheck.repository.DeviceCheckDetailDao;
import com.tykj.dev.device.confirmcheck.repository.DeviceCheckStatDao;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.subject.vo.FileVo;
import com.tykj.dev.device.matching.service.MatchingDeviceBillService;
import com.tykj.dev.device.matching.subject.domin.MatchingDeviceBill;
import com.tykj.dev.device.packing.service.PackingLibraryService;
import com.tykj.dev.device.repair.repository.RepairBackBillDao;
import com.tykj.dev.device.repair.repository.RepairSendBillDao;
import com.tykj.dev.device.repair.service.RepairBackBillService;
import com.tykj.dev.device.repair.service.RepairBillService;
import com.tykj.dev.device.repair.service.RepairSendBillService;
import com.tykj.dev.device.repair.subject.domin.RepairBackBill;
import com.tykj.dev.device.repair.subject.domin.RepairBill;
import com.tykj.dev.device.repair.subject.domin.RepairSendBill;
import com.tykj.dev.device.retired.service.DeviceRetiredBillService;
import com.tykj.dev.device.selfcheck.service.SelfCheckBillService;
import com.tykj.dev.device.selfcheck.subject.domin.SelfCheckBill;
import com.tykj.dev.device.storage.service.StorageBillService;
import com.tykj.dev.device.storage.subject.domin.StorageBill;
import com.tykj.dev.device.task.service.TaskLogService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.bto.TaskLogBto;
import com.tykj.dev.device.train.dao.TrainThemeDao;
import com.tykj.dev.device.train.dao.WorkHandoverDao;
import com.tykj.dev.device.user.util.UserUtils;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.base.BusinessEnum;
import com.tykj.dev.misc.base.StatusEnum;
import com.tykj.dev.misc.utils.SpringUtils;
import com.tykj.dev.rfid.service.RfidChangeBillService;
import com.tykj.dev.union.vo.SaveBillSignatureVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zsp
 */
@RestController
@RequestMapping("/signature")
@AutoDocument
@Api(tags = "电子签名模块",description = "电子签名模块")
@Slf4j
public class BillSignature {

    @Autowired
    private AllotBillService allotBillService;

    @Autowired
    private AllotBackBillService allotBackBillService;

    @Autowired
    private RepairSendBillService repairSendBillService;

    @Autowired
    private RepairBackBillService repairBackBillService;

    @Autowired
    private TaskService taskService;

    @PostMapping("/saveBillSignature")
    @ApiOperation(value = "保存账单的电子签名")
    public ResponseEntity<String> saveBillSignature(@RequestBody SaveBillSignatureVo saveBillSignatureVo){
        Integer businessType = saveBillSignatureVo.getBusinessType();
        TaskBto taskBto = taskService.get(saveBillSignatureVo.getTaskId());
        switch (businessType){
            case 3:
                AllotBill allotBill = allotBillService.getOne(taskBto.getBillId());
                BeanUtils.copyProperties(saveBillSignatureVo,allotBill);
                allotBillService.addEntity(allotBill);
                return ResponseEntity.ok("电子签名保存成功");
            default:
                return ResponseEntity.ok("");
        }
    }


}
