package com.tykj.dev.union;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName AreaController.java
 * @Description TODO
 * @createTime 2020年09月04日 13:34:00
 */

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.subject.vo.UpdateUnitVo;
import com.tykj.dev.device.matching.service.MatchingDeviceBillService;
import com.tykj.dev.device.matching.service.MatchingDeviceLibraryService;
import com.tykj.dev.device.matching.subject.vo.MatchingUnitVo;
import com.tykj.dev.device.user.cache.UnitsCache;
import com.tykj.dev.device.user.subject.dao.AreaDao;
import com.tykj.dev.device.user.subject.entity.Area;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.service.AreaService;
import com.tykj.dev.device.user.subject.service.UnitsService;
import com.tykj.dev.misc.exception.ApiException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

/**
 * 区域视图层
 */
@RestController
public class RunController {

    @Resource
    UnitsCache unitsCache;

    @Resource
    UnitsService unitsService;

    @Autowired
    private DeviceLibraryService deviceLibraryService;

    @Autowired
    private MatchingDeviceLibraryService matchingDeviceLibraryService;

    @ApiOperation(value = "修改单位名称从而修改配套设备的创建单位", notes = "修改单位名称从而修改配套设备的创建单位")
    @PostMapping("/device/updateDeviceLocationAndOwnUnit")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity<String> updateMatchingDeviceCreateUnitName(@RequestBody Units units) {
        String name = unitsCache.findById(units.getUnitId()).getName();
        UpdateUnitVo updateUnitVo = new UpdateUnitVo();
        MatchingUnitVo matchingUnitVo = new MatchingUnitVo();
        //调用单位
        unitsService.updateUnit(units);
        if (!name.equals(units.getName())){
            updateUnitVo.setOriginUnitName(name);
            updateUnitVo.setUpdateUnitName(units.getName());
            matchingUnitVo.setOriginUnitName(name);
            matchingUnitVo.setUpdateUnitName(units.getName());
            CompletableFuture.runAsync(()->deviceLibraryService.updateDeviceLocationAndOwnUnit(updateUnitVo));
            CompletableFuture.runAsync(()->matchingDeviceLibraryService.updateMatchingDeviceCreateUnitNameByUnitName(matchingUnitVo));
        }
        return ResponseEntity.ok("修改成功");
    }


}
