package com.tykj.dev.union;


import com.tykj.dev.device.library.service.DeviceLibraryCacheService;
import com.tykj.dev.device.library.subject.vo.FileVo;
import com.tykj.dev.device.matching.service.MatchingDeviceBillService;
import com.tykj.dev.device.matching.subject.domin.MatchingDeviceBill;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 增强更新缓存aop
 *
 * @author zsp
 */
@Slf4j
@Aspect
@Component
public class UpdateCacheAspect {

    /**
     * 业务新状态
     */
    @Autowired
    private DeviceLibraryCacheService deviceLibraryCacheService;

    /**
     * 更新缓存定义切入点
     */
    @Pointcut("@annotation(com.tykj.dev.config.UpdateCache)")
    public void operationLog() {
    }

    /**
     * 新增结果返回后触发
     */
    @AfterReturning(pointcut = "operationLog()")
    public void doAfterReturning(JoinPoint point) {
        log.info("通过AOP更新缓存");
        deviceLibraryCacheService.asyncUpdateCache();
    }

}
