package com.tykj.dev.device.user.base.req;

import com.tykj.dev.device.user.base.ret.AreaVo;
import com.tykj.dev.device.user.base.ret.LeftNavigation;
import com.tykj.dev.device.user.base.ret.UnitsTrainVo;
import com.tykj.dev.device.user.base.ret.UnitsVo;
import com.tykj.dev.device.user.subject.entity.Area;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.modelmapper.ModelMapper;

import javax.persistence.*;
import java.util.UUID;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Units.java
 * @Description 单位对象
 * @createTime 2020年07月28日 09:23:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "单位添加对象", description = "单位添加对象")
public class UnitsAddVo {

    /**
     * 单位名称
     */
    @ApiModelProperty(value = "单位名称", name = "unitName", example = "12321L")
    private String name;

    /**
     * 单位描述
     */
    @ApiModelProperty(value = "单位描述", name = "unitDesc", example = "12321L")
    private String unitDesc;

    /**
     * 等级
     */
    @ApiModelProperty(value = "等级", name = "level", example = "12321L")
    private Integer level;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序", name = "showOrder", example = "12321L")
    private Integer showOrder;

    @ApiModelProperty(value = "装备配用范围的指定")
    private Integer packingMatchingRange;

    @ApiModelProperty(value = "是否代管")
    private Integer escrow;

    @ApiModelProperty(value = "展示区域id")
    private Integer exhibitionId;

    @ApiModelProperty(value = "上级单位ID")
    private Integer parentUnitId;

    public Units toUnits(){
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, Units.class);
    }

}
