package com.tykj.dev.device.user.cache;

import com.tykj.dev.device.user.subject.entity.AreaExhibition;
import com.tykj.dev.device.user.subject.entity.Units;
import lombok.Data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName AreaExhibitionCache.java
 * @Description TODO
 * @createTime 2021年11月09日 14:36:00
 */
@Data
public class AreaExhibitionCache {
    private Map<Integer, AreaExhibition> idMap;

    private List<AreaExhibition> areaExhibitions;



    public AreaExhibitionCache(List<AreaExhibition> areaExhibitionList){
        this.idMap = areaExhibitionList.stream().collect(Collectors.toMap(AreaExhibition::getId, Function.identity()));
        this.areaExhibitions=areaExhibitionList;
    }

    public Map<Integer, AreaExhibition> getIdMap() {
        return idMap;
    }

    public AreaExhibition findById(Integer id) {
        return idMap.get(id);
    }

    public List<AreaExhibition> findAll(){
        return new ArrayList<>(idMap.values());
    }

    /**
     * 查询大于等新序号，小于原序号
     * @return
     */
    public List<AreaExhibition> findListGeNewAndLtOriginal(Integer newOrder,Integer OriginalOrder){
        return new ArrayList<>(idMap.values()).stream().filter(areaExhibition -> (areaExhibition.getOrders()>=newOrder) &&(areaExhibition.getOrders() < OriginalOrder)).collect(Collectors.toList());
    }
    /**
     * 查询大于原序号，小于等于新序号
     */
    public List<AreaExhibition> findListLgOriginalAndLeNew(Integer newOrder,Integer OriginalOrder){
        return new ArrayList<>(idMap.values()).stream().filter(areaExhibition -> (areaExhibition.getOrders()<=newOrder) &&(areaExhibition.getOrders() > OriginalOrder)).collect(Collectors.toList());
    }

    /**
     * 根据区域id查询下级以及
     */
    public List<AreaExhibition> findByFatherId(Integer fatherId){
       return new ArrayList<>(idMap.values()).stream().filter(areaExhibition -> fatherId.equals(areaExhibition.getFatherId())).collect(Collectors.toList());
    }

    public AreaExhibitionCache refresh(List<AreaExhibition> areaExhibitionList){
        this.idMap = areaExhibitionList.stream().collect(Collectors.toMap(AreaExhibition::getId, Function.identity()));
        this.areaExhibitions=areaExhibitionList;
        return this;
    }

    public Map<Integer,String> checkSpecial(){
       Map<Integer,String> map=new HashMap<>();
       map.put(1,idMap.get(3).getAreaName());
       map.put(2,idMap.get(4).getAreaName());
       return map;
    }
}
