package com.tykj.dev.device.user.cache;

import com.tykj.dev.device.user.subject.entity.Units;
import lombok.Data;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Data
public class UnitsCache {

    private Map<Integer, Units> idMap;

    private Map<Integer,Units> areaIdMpa;

    public UnitsCache(List<Units> unitsList){
        this.idMap = unitsList.stream().collect(Collectors.toMap(Units::getUnitId, Function.identity()));
        this.areaIdMpa=unitsList.stream().collect(Collectors.toMap(Units::getAreaId,Function.identity()));
    }

    public Map<Integer, Units> getIdMap() {
        return idMap;
    }


    public Units findByAreaId(Integer areaId){
       return areaIdMpa.get(areaId);
    }

    public Units findById(Integer id) {
        return idMap.get(id);
    }

    public List<Units> findAll(){
        return new ArrayList<>(idMap.values());
    }

    public List<Units> findAllByAreaExhibitionId(Integer areaExhibitionId){
        return new ArrayList<>(idMap.values()).stream().filter(units -> units.getExhibitionId().equals(areaExhibitionId)).collect(Collectors.toList());
    }

    public List<Units> findAllByAreaExhibitionIdList(List<Integer> areaExhibitionIds){
        return new ArrayList<>(idMap.values()).stream().filter(units -> areaExhibitionIds.contains(units.getExhibitionId())).collect(Collectors.toList());
    }

    /**
     * 根据当前单位id查询下级以及本级
     */
    public List<Units> findByIdSubordinateAndOneself(Integer unitId){
        Units units=idMap.get(unitId);
        return new ArrayList<>(idMap.values()).stream().filter(units1 -> units1.getExhibitionId().equals(units.getExhibitionId())).collect(Collectors.toList());
    }

    /**
     * 查询大于等新序号，小于原序号
     * @return
     */
    public List<Units> findListGeNewAndLtOriginal(Integer newOrder,Integer OriginalOrder){
       return new ArrayList<>(idMap.values()).stream().filter(units -> (units.getShowOrder()>=newOrder) &&(units.getShowOrder() < OriginalOrder)).collect(Collectors.toList());
    }
    /**
     * 查询大于原序号，小于等于新序号
     */
    public List<Units> findListLgOriginalAndLeNew(Integer newOrder,Integer OriginalOrder){
        return new ArrayList<>(idMap.values()).stream().filter(units -> (units.getShowOrder()<=newOrder) &&(units.getShowOrder() > OriginalOrder)).collect(Collectors.toList());
    }

    public UnitsCache refresh(List<Units> unitsList){
        this.idMap = unitsList.stream().collect(Collectors.toMap(Units::getUnitId, Function.identity()));
        this.areaIdMpa=unitsList.stream().collect(Collectors.toMap(Units::getAreaId,Function.identity()));
        return this;
    }

    /**
     * 根据区域id的集合查询所有的单位
     */
    public List<Units> findByAllAreaIds(List<Integer> areaIds){
        return new ArrayList<>(idMap.values()).stream().filter(units -> areaIds.contains(units.getAreaId())).collect(Collectors.toList());
    }


    /**
     * 根据单位id的集合给集合进行排序
     * @param ids 单位id集合
     * @return 单位id集合
     */
    public List<Integer> sortReasonUnitsIds(List<Integer> ids){

       return ids.stream().sorted(Comparator.comparing(id->idMap.get(id).getShowOrder())).collect(Collectors.toList());
    }


    public List<Units> sortReasonUnits(List<Units> unitsList){
        return unitsList.stream().sorted(Comparator.comparing(Units::getShowOrder)).collect(Collectors.toList());
    }

}
