package com.tykj.dev.device.user.read.subject.domin;

import com.tykj.dev.device.user.read.subject.bto.MessageBto;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.modelmapper.ModelMapper;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * 阅知信息表
 * @author dengdiyi
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update message set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("阅知信息表")
public class Message {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(name = "主键id")
    private Integer id;

    @ApiModelProperty(name = "阅知信息对应业务Id")
    private Integer taskId;

    @ApiModelProperty(value = "业务类型主键id")
    private Integer businessType;

    @ApiModelProperty(value = "信息内容")
    @Column(name = "content",columnDefinition = "TEXT")
    private String content;

    @Column(name = "involve_users",columnDefinition = "TEXT")
    @ApiModelProperty(value = "阅知人员id(x作为分隔符),例如x1x2x,意为id为1,2的用户待阅知该信息")
    private String involveUsers;

    @Column(name = "complete_users",columnDefinition = "TEXT")
    @ApiModelProperty(value = "已完成人员id(x作为分隔符),例如x1x2x,意为id为1,2的用户已完成阅知该信息")
    private String completeUsers;

    @Column(name = "user_read_detail",columnDefinition = "TEXT")
    @ApiModelProperty(value = "用户阅读信息")
    private String userReadDetail;

    @ApiModelProperty(value = "创建用户id")
    @CreatedBy
    private Integer createUserId;

    @ApiModelProperty(value = "创建时间")
    @CreatedDate
    private Date createTime;

    @ApiModelProperty(value = "更新用户id")
    @LastModifiedBy
    private Integer updateUserId;

    @ApiModelProperty(value = "更新时间")
    @LastModifiedDate
    private Date updateTime;

    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    @Lob
    @Column(name = "record",columnDefinition = "TEXT")
    @ApiModelProperty(value = "附加信息")
    private String record;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

    @ApiModelProperty(value = "是否高亮(0：不是，1：是)")
    private Integer isHighLight = 0;

    @ApiModelProperty(value = "是否置顶(0：不是，1：是)")
    private Integer isTop;

    /**
     * do类转化为bto类
     */
    public MessageBto parse2Bto() {
        //modelMap复制
        ModelMapper mapper = BeanHelper.getUserMapper();
        MessageBto messageBto = mapper.map(this, MessageBto.class);
        //解析组合字段并添加
        messageBto.setInvolveUserIdList(StringSplitUtil.userIdSplit(this.involveUsers));
        messageBto.setUserReadDetailList(StringSplitUtil.userIdSplit(this.userReadDetail));
        messageBto.setCompleteUserIdList(StringSplitUtil.userIdSplit(this.completeUsers));
        return messageBto;
    }

}
