package com.tykj.dev.device.user.subject.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.user.subject.entity.AreaExhibition;
import com.tykj.dev.device.user.subject.service.AreaExhibitionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName AreaExhibitionController.java
 * @Description TODO
 * @createTime 2021年11月09日 11:29:00
 */
@RestController
@AutoDocument
@Api(tags = "区域展示模块", description = "提供区域展示模块接口")
@RequestMapping("/areaExhibition")
public class AreaExhibitionController {

    @Autowired
    AreaExhibitionService areaExhibitionService;

    @GetMapping("/finaAll")
    @ApiOperation(value = "查询所有区域列表", notes = "查询所有区域列表")
    public ResponseEntity selectFindAll() {
        return ResponseEntity.ok(areaExhibitionService.finaAllAreaExhibition());
    }


    @PostMapping("/save")
    @ApiOperation(value = "保存区域展示对象", notes = "保存区域展示对象")
    public ResponseEntity saveExhibition(@RequestBody AreaExhibition areaExhibition) {
        return ResponseEntity.ok(areaExhibitionService.save(areaExhibition));
    }

}