package com.tykj.dev.device.user.subject.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.user.base.req.UnitStoreLocationVo;
import com.tykj.dev.device.user.subject.entity.UnitStoreLocation;
import com.tykj.dev.device.user.subject.service.UnitStoreLocationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UnitStoreLocationController.java
 * @Description TODO
 * @createTime 2021年11月08日 13:23:00
 */
@RestController
@AutoDocument
@Api(tags = "各单位存放位置", description = "提供用户相关的接口")
@RequestMapping("/unitStoreLocation")
@Slf4j
public class UnitStoreLocationController {
    @Autowired
    UnitStoreLocationService unitStoreLocationService;


    @PostMapping(value = "/unitIdAndTypeName")
    @ApiOperation(value = "根据单位ID以及字段名称查询单位存储列表", notes = "返回单位对象")
    public ResponseEntity unitIdAndTypeName(@RequestBody UnitStoreLocationVo unitStoreLocationVo) {
        return ResponseEntity.ok(unitStoreLocationService.findAllByUnitIdAndTypeName(unitStoreLocationVo));
    }


    @PostMapping(value = "/save")
    @ApiOperation(value = "添加库房位置对象", notes = "添加库房位置对象")
    public ResponseEntity unitIdAndTypeName(@RequestBody UnitStoreLocation unitStoreLocation) {
        return ResponseEntity.ok(unitStoreLocationService.save(unitStoreLocation));
    }

}
