package com.tykj.dev.device.user.subject.controller;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName AreaController.java
 * @Description TODO
 * @createTime 2020年09月04日 13:34:00
 */

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.service.UserLogService;
import com.tykj.dev.misc.exception.ApiException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

/**
 * 区域视图层
 */
@RestController
@AutoDocument
@Api(tags = "用户档案模块", description = "提供用户档案的接口")
@RequestMapping("/userLog")
public class UserLogController {
    @Autowired
    UserLogService userLogService;

    @GetMapping("/find/select/{userId}")
    @ApiOperation(value = "查询用户履历", notes = "查询用户履历")
    public ResponseEntity selectPage(@PathVariable Integer userId){

        return ResponseEntity.ok(userLogService.findAllByuserID(userId));
    }

    @GetMapping("/find")
    @ApiOperation(value = "303", notes = "查询用户履历")
    public ResponseEntity selectPage1(){
        throw new ApiException(ResponseEntity.status(303).body("错误"));
    }


    @GetMapping("/test")
    @ApiOperation(value = "查询用户履历", notes = "查询用户履历")
    public ResponseEntity selectPage2(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser){
        return ResponseEntity.ok(securityUser.getCurrentUserInfo());
    }
}
