package com.tykj.dev.device.user.subject.dao;

import com.tykj.dev.device.user.subject.entity.Units;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.security.core.parameters.P;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface UnitsDao extends JpaRepository<Units, Integer>, JpaSpecificationExecutor<Units> {

    /**
     * 查询是否代管的单位
     * @param tag 1_代管，0_非代管
     * @return units
     */
    Optional<List<Units>> findAllByEscrow(Integer tag);


    /**
     * 根据Type和level查询单位
     * @return units
     */
    Optional<List<Units>> findAllByTypeInAndLevelIn(List<Integer> type, List<Integer> level);

    List<Units> findAllByTypeAndLevel(Integer type, Integer level);

    List<Units> findAllByLevel(Integer level);

    List<Units> findAllByAreaId(Integer areaId);

    Optional<List<Units>> findAllByName(String unitName);

    Units findByName(String unitName);

    List<Units> findAllByLevelGreaterThanEqual(Integer level);

    List<Units> findAllByTypeNotIn(List<Integer> ids);

    List<Units> findAllByTypeNotInAndLevelIn(List<Integer> ids,List<Integer> levels);

    List<Units> findAllByTypeInOrLevelIn(List<Integer> typeIds, List<Integer> levelIds);

    List<Units> findByAreaIdIn(List<Integer> areaIds);

    List<Units> findAllByAreaIdIn(List<Integer> ids);

    List<Units> findByAreaId(Integer area);

    List<Units> findByIdDel(Integer idDel);

    @Query("select o.areaId from Units o where o.name = ?1")
    int findAreaIdByName(String unitName);

    @Query("select o.areaId from Units o where o.unitId=?1")
    int findAreaId(int id);

    Units findTopByOrderByShowOrderDesc();

    Units findByAreaIdAndLevel(Integer areaId, Integer level);

    default Units findByAreaIdEquals() {
        return findByAreaIdEquals();
    }

    Units findByAreaIdEquals(Integer areaId);

    List<Units> findAllByLevelIn(List<Integer> levels);

    List<Units> findAllByType(Integer type);

    List<Units> findByTypeAndEscrow(int type, int escrow);

}
