package com.tykj.dev.device.user.subject.dao;

import com.tykj.dev.device.user.subject.entity.User;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import javax.transaction.Transactional;
import java.util.List;

@Repository
public interface UserDao extends JpaRepository<User, Integer>, JpaSpecificationExecutor<User> {
    User findByUsername(String userName);

    List<User> findAllByUnitsId(Integer unitsId);

    List<User> findAllByUnitsIdIn(List<Integer> ids);

    List<User> findAllByUserIdIn(List<Integer> userIds);

    @Query("select max(o.showOrder) from User o where o.unitsId = ?1")
    Integer maxShowOrder(Integer unitsId);

    List<User> findAllByIsDel(Integer isDel);

    @Transactional
    @Modifying
    @Query("update User o set o.trainStatus = :trainStatus where o.userId in :userIds")
    int upDateUserIdsAndTrainStatus(@Param("userIds") List<Integer> userIds,Integer trainStatus);

    User findByName(String name);

    User findByNameAndUnitsId(String name,Integer unitsId);

    List<User> findBySubordinateId(Integer userID);

}
