package com.tykj.dev.device.user.subject.entity;

import com.tykj.dev.device.user.base.ret.LeftNavigation;
import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Transient;
import java.util.UUID;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName AreaExhibition.java
 * @Description TODO
 * @createTime 2021年11月09日 09:12:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "地区提供展示对象", description = "地区提供展示信息")
public class AreaExhibition extends BaseEntity {

    /**
     * 区域名称
     */
    private String areaName;

    /**
     * 区域描述
     */
    @Column(name = "des",columnDefinition = "TEXT")
    private String des;

    /**
     * 排序
     */
    private Integer orders;

    /**
     * 父类id
     */
    private Integer fatherId;

    /**
     * 父类名称
     */
    @Transient
    private String fatherName;

    public LeftNavigation toLeftNavigation(){
        return new LeftNavigation(this.getId(),areaName,null, UUID.randomUUID().toString(),1,Double.valueOf(orders).intValue(),null);
    }
}
